/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.skin;

import dev.imb11.skinshuffle.SkinShuffle;
import dev.imb11.skinshuffle.client.skin.BackedSkin;
import dev.imb11.skinshuffle.client.skin.ConfigSkin;
import dev.imb11.skinshuffle.util.SkinTextureSafetyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import org.jetbrains.annotations.Nullable;

public abstract class FileBackedSkin
extends BackedSkin {
    @Nullable
    private Boolean exists;
    private long lastModifiedTime = -1L;

    @Override
    protected Object getTextureUniqueness() {
        try {
            if (Files.exists(this.getFile(), new LinkOption[0])) {
                this.lastModifiedTime = Files.getLastModifiedTime(this.getFile(), new LinkOption[0]).toMillis();
            }
            return this.getFile().toString() + "_" + this.lastModifiedTime;
        }
        catch (IOException e) {
            SkinShuffle.LOGGER.warn("Failed to get last modified time for file: " + String.valueOf(this.getFile()), (Throwable)e);
            return this.getFile();
        }
    }

    @Override
    @Nullable
    protected class_1044 loadTexture(Runnable completionCallback) {
        class_1043 class_10432;
        block9: {
            InputStream inputStream = Files.newInputStream(this.getFile(), new OpenOption[0]);
            try {
                class_1011 image = SkinTextureSafetyUtil.processTexture(class_1011.method_4310((class_1011.class_1012)class_1011.class_1012.field_4997, (InputStream)inputStream));
                if (image == null) {
                    throw new RuntimeException("Texture is null!");
                }
                class_1043 texture = new class_1043(() -> String.valueOf(Math.abs(this.getTextureUniqueness().hashCode())), image);
                completionCallback.run();
                class_10432 = texture;
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    SkinShuffle.LOGGER.warn("Failed to load skin from file: " + String.valueOf(this.getFile()), (Throwable)e);
                    return null;
                }
            }
            inputStream.close();
        }
        return class_10432;
    }

    public void delete() {
        if (this.fileExists()) {
            try {
                Files.delete(this.getFile());
                this.exists = false;
                this.setTexture(null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean fileExists() {
        return Files.isReadable(this.getFile());
    }

    protected abstract Path getFile();

    @Override
    public ConfigSkin saveToConfig() {
        try {
            String textureName = String.valueOf(Math.abs(this.getTextureUniqueness().hashCode()));
            ConfigSkin configSkin = new ConfigSkin(textureName, this.getModel());
            Files.copy(this.getFile(), configSkin.getFile(), StandardCopyOption.REPLACE_EXISTING);
            return configSkin;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save skin to config", e);
        }
    }
}

