/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.networking;

import dev.imb11.skinshuffle.api.data.SkinQueryResult;
import dev.imb11.skinshuffle.client.config.SkinPresetManager;
import dev.imb11.skinshuffle.networking.HandshakePayload;
import dev.imb11.skinshuffle.networking.RefreshPlayerListEntryPayload;
import dev.imb11.skinshuffle.networking.SkinRefreshPayload;
import dev.imb11.skinshuffle.util.SkinShuffleClientPlayer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_8710;

public class ClientSkinHandling {
    private static boolean handshakeTakenPlace = false;
    private static boolean reconnectRequired = false;

    public static boolean isReconnectRequired() {
        return reconnectRequired;
    }

    public static void setReconnectRequired(boolean reconnectRequired) {
        ClientSkinHandling.reconnectRequired = reconnectRequired;
    }

    public static boolean isInstalledOnServer() {
        return handshakeTakenPlace;
    }

    public static void sendRefresh(SkinQueryResult result) {
        ClientPlayNetworking.send((class_8710)new SkinRefreshPayload(result.toProperty()));
    }

    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> SkinPresetManager.setApiPreset(null));
        ClientPlayConnectionEvents.INIT.register((handler, client) -> {
            if (client.field_1687 == null) {
                return;
            }
            handshakeTakenPlace = false;
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            handshakeTakenPlace = false;
            ClientSkinHandling.setReconnectRequired(false);
            SkinPresetManager.setApiPreset(null);
        });
        ClientPlayNetworking.registerGlobalReceiver(HandshakePayload.PACKET_ID, (payload, context) -> {
            handshakeTakenPlace = true;
        });
        ClientPlayNetworking.registerGlobalReceiver(RefreshPlayerListEntryPayload.PACKET_ID, (payload, context) -> {
            int id = payload.entityID();
            class_310 client = context.client();
            client.execute(() -> {
                class_1297 entity;
                class_638 world = client.field_1687;
                if (world != null && (entity = world.method_8469(id)) instanceof class_742) {
                    class_742 player = (class_742)entity;
                    ((SkinShuffleClientPlayer)player).skinShuffle$refreshPlayerListEntry();
                }
            });
        });
    }
}

