/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.util;

import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.imb11.skinshuffle.SkinShuffle;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class SkinCacheRegistry {
    private static final Path CACHE_FILE = SkinShuffle.DATA_DIR.resolve("skin-caches.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final HashMap<String, Path> DOWNLOADED_SKIN_CACHES = new HashMap();
    private static final HashMap<String, String> UPLOADED_SKIN_CACHES = new HashMap();

    private static void saveCache() {
        try {
            JsonObject object = new JsonObject();
            JsonObject uploaded = new JsonObject();
            JsonObject downloaded = new JsonObject();
            for (Map.Entry<String, Path> entry : DOWNLOADED_SKIN_CACHES.entrySet()) {
                downloaded.addProperty(entry.getKey(), entry.getValue().toString());
            }
            for (Map.Entry<String, Object> entry : UPLOADED_SKIN_CACHES.entrySet()) {
                uploaded.addProperty(entry.getKey(), (String)entry.getValue());
            }
            object.add("uploaded", (JsonElement)uploaded);
            object.add("downloaded", (JsonElement)downloaded);
            String jsonString = GSON.toJson((JsonElement)object);
            Files.writeString(CACHE_FILE, (CharSequence)jsonString, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to save SkinCacheRegistry to file.", e);
        }
    }

    public static void initialize() {
        try {
            String hash;
            if (!CACHE_FILE.toFile().exists()) {
                SkinCacheRegistry.saveCache();
            }
            String jsonString = Files.readString(CACHE_FILE);
            JsonObject jsonObject = (JsonObject)GSON.fromJson(jsonString, JsonObject.class);
            JsonObject uploadedCaches = jsonObject.get("uploaded").getAsJsonObject();
            JsonObject downloadedCaches = jsonObject.get("downloaded").getAsJsonObject();
            for (Map.Entry entry : uploadedCaches.entrySet()) {
                hash = (String)entry.getKey();
                String url = ((JsonElement)entry.getValue()).getAsString();
                UPLOADED_SKIN_CACHES.put(hash, url);
            }
            for (Map.Entry entry : downloadedCaches.entrySet()) {
                hash = (String)entry.getKey();
                Path path = Path.of(((JsonElement)entry.getValue()).getAsString(), new String[0]);
                DOWNLOADED_SKIN_CACHES.put(hash, path);
            }
            SkinCacheRegistry.validateCaches();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize SkinCacheRegistry", e);
        }
    }

    @Nullable
    public static String getCachedUploadedSkin(File skinTexture) throws IOException {
        String hash = SkinCacheRegistry.getHash(Files.readAllBytes(skinTexture.toPath()));
        return UPLOADED_SKIN_CACHES.get(hash);
    }

    public static void saveUploadedSkin(File skinTexture, String url) throws IOException {
        String hash = SkinCacheRegistry.getHash(Files.readAllBytes(skinTexture.toPath()));
        UPLOADED_SKIN_CACHES.put(hash, url);
        SkinCacheRegistry.saveCache();
    }

    private static String getHash(byte[] skinTexture) {
        return Hashing.sha256().hashBytes(skinTexture).toString();
    }

    public static void validateCaches() {
        ArrayList<String> hashesToInvalidate = new ArrayList<String>();
        for (Map.Entry<String, Path> entry : DOWNLOADED_SKIN_CACHES.entrySet()) {
            String hash = entry.getKey();
            Path path = entry.getValue();
            if (path.toFile().exists()) continue;
            hashesToInvalidate.add(hash);
        }
        hashesToInvalidate.forEach(DOWNLOADED_SKIN_CACHES::remove);
    }
}

