/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.lambdaevents;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.lenni0451.lambdaevents.AHandler;
import net.lenni0451.lambdaevents.EventHandler;
import net.lenni0451.lambdaevents.IEventFilter;
import net.lenni0451.lambdaevents.IExceptionHandler;
import net.lenni0451.lambdaevents.IGenerator;
import net.lenni0451.lambdaevents.StopCall;
import net.lenni0451.lambdaevents.handler.ConsumerHandler;
import net.lenni0451.lambdaevents.handler.RunnableHandler;
import net.lenni0451.lambdaevents.types.ICancellableEvent;
import net.lenni0451.lambdaevents.utils.EventUtils;

public class LambdaManager {
    private final Map<Class<?>, List<AHandler>> handlers;
    private final Map<Class<?>, AHandler[]> handlerArrays;
    private final Map<Class<?>, Class<?>[]> parentsCache;
    private final Supplier<List<AHandler>> listSupplier;
    private final IGenerator generator;
    @Nullable
    private IEventFilter eventFilter = null;
    private IExceptionHandler exceptionHandler = IExceptionHandler.infoPrint();
    private boolean registerSuperHandler = false;
    private boolean alwaysCallParents = false;

    public static LambdaManager basic(IGenerator generator) {
        return new LambdaManager(HashMap::new, ArrayList::new, generator);
    }

    public static LambdaManager threadSafe(IGenerator generator) {
        return new LambdaManager(ConcurrentHashMap::new, CopyOnWriteArrayList::new, generator);
    }

    public LambdaManager(Supplier<Map> mapSupplier, Supplier<List<AHandler>> listSupplier, IGenerator generator) {
        this.handlers = mapSupplier.get();
        this.handlerArrays = mapSupplier.get();
        this.parentsCache = mapSupplier.get();
        this.listSupplier = listSupplier;
        this.generator = generator;
    }

    public LambdaManager setEventFilter(@Nullable IEventFilter eventFilter) {
        this.eventFilter = eventFilter;
        return this;
    }

    public LambdaManager setExceptionHandler(IExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public LambdaManager setRegisterSuperHandler(boolean registerSuperHandler) {
        this.registerSuperHandler = registerSuperHandler;
        return this;
    }

    public LambdaManager setAlwaysCallParents(boolean alwaysCallParents) {
        this.alwaysCallParents = alwaysCallParents;
        return this;
    }

    @Nonnull
    public <T> T call(T event) {
        if (this.alwaysCallParents) {
            return this.callParents(event);
        }
        if (this.eventFilter != null && !this.eventFilter.check(event.getClass(), IEventFilter.CheckType.CALL)) {
            return event;
        }
        this.call(event.getClass(), event);
        return event;
    }

    @Nonnull
    public <T> T callParents(T event) {
        if (this.eventFilter != null && !this.eventFilter.check(event.getClass(), IEventFilter.CheckType.CALL)) {
            return event;
        }
        for (Class clazz2 : this.parentsCache.computeIfAbsent(event.getClass(), clazz -> {
            LinkedHashSet parents = new LinkedHashSet();
            EventUtils.getSuperClasses(parents, clazz);
            return parents.toArray(new Class[0]);
        })) {
            this.call(clazz2, event);
        }
        return event;
    }

    private <T> void call(Class<?> clazz, T event) {
        AHandler[] handlers = this.handlerArrays.get(clazz);
        if (handlers == null) {
            return;
        }
        ICancellableEvent cancellable = event instanceof ICancellableEvent ? (ICancellableEvent)event : null;
        for (AHandler handler : handlers) {
            if (cancellable != null && !handler.shouldHandleCancelled() && cancellable.isCancelled()) continue;
            try {
                handler.call(event);
            }
            catch (StopCall ignored) {
                return;
            }
            catch (Throwable t) {
                this.exceptionHandler.handle(handler, event, t);
            }
        }
    }

    public void register(Class<?> owner) {
        this.register((Class<?>)null, owner);
    }

    public void register(@Nullable Class<?> event, Class<?> owner) {
        this.register(event, owner, null, true, false);
    }

    public void register(Object owner) {
        this.register(null, owner);
    }

    public void register(@Nullable Class<?> event, Object owner) {
        this.register(event, owner.getClass(), owner, false, this.registerSuperHandler);
    }

    public void registerSuper(Object owner) {
        this.registerSuper(null, owner);
    }

    public void registerSuper(@Nullable Class<?> event, Object owner) {
        this.register(event, owner.getClass(), owner, false, true);
    }

    public void registerRunnable(Runnable runnable, Class<?> ... events) {
        this.registerRunnable(runnable, 0, events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRunnable(Runnable runnable, int priority, Class<?> ... events) {
        if (events.length == 0) {
            throw new IllegalArgumentException("No events specified");
        }
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            for (Class<?> event : events) {
                if (this.eventFilter != null && !this.eventFilter.check(event, IEventFilter.CheckType.EXPLICIT_REGISTER)) continue;
                List handlers = this.handlers.computeIfAbsent(event, key -> this.listSupplier.get());
                handlers.add(new RunnableHandler(runnable.getClass(), runnable, EventUtils.newEventHandler(priority), runnable));
                this.checkCallChain(event, handlers);
            }
        }
    }

    public void registerConsumer(Consumer<?> consumer, Class<?> ... events) {
        this.registerConsumer(consumer, 0, events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConsumer(Consumer<?> consumer, int priority, Class<?> ... events) {
        if (events.length == 0) {
            throw new IllegalArgumentException("No events specified");
        }
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            for (Class<?> event : events) {
                if (this.eventFilter != null && !this.eventFilter.check(event, IEventFilter.CheckType.EXPLICIT_REGISTER)) continue;
                List handlers = this.handlers.computeIfAbsent(event, key -> this.listSupplier.get());
                handlers.add(new ConsumerHandler(consumer.getClass(), consumer, EventUtils.newEventHandler(priority), consumer));
                this.checkCallChain(event, handlers);
            }
        }
    }

    @Deprecated
    public void register(Runnable runnable, Class<?> ... events) {
        this.registerRunnable(runnable, events);
    }

    @Deprecated
    public void register(Runnable runnable, int priority, Class<?> ... events) {
        this.registerRunnable(runnable, priority, events);
    }

    @Deprecated
    public void register(Consumer<?> consumer, Class<?> ... events) {
        this.registerConsumer(consumer, events);
    }

    @Deprecated
    public void register(Consumer<?> consumer, int priority, Class<?> ... events) {
        this.registerConsumer(consumer, priority, events);
    }

    private void register(@Nullable Class<?> event, Class<?> owner, @Nullable Object instance, boolean isStatic, boolean registerSuperHandler) {
        EventHandler annotation;
        Predicate<Class<?>> eventFilter;
        if (event == null) {
            eventFilter = e -> this.eventFilter == null || this.eventFilter.check((Class<?>)e, IEventFilter.CheckType.REGISTER);
        } else {
            if (this.eventFilter != null && !this.eventFilter.check(event, IEventFilter.CheckType.EXPLICIT_REGISTER)) {
                return;
            }
            eventFilter = e -> e.equals(event);
        }
        for (EventUtils.MethodHandler methodHandler : EventUtils.getMethods(owner, method -> Modifier.isStatic(method.getModifiers()) == isStatic, registerSuperHandler)) {
            annotation = methodHandler.getAnnotation();
            Method method2 = methodHandler.getMethod();
            EventUtils.verify(methodHandler.getOwner(), annotation, method2);
            for (Class<?> eventClass : EventUtils.getEvents(annotation, method2, eventFilter)) {
                this.registerMethod(methodHandler.getOwner(), instance, annotation, method2, eventClass, method2.getParameterCount() == 0);
            }
        }
        for (EventUtils.FieldHandler fieldHandler : EventUtils.getFields(owner, field -> Modifier.isStatic(field.getModifiers()) == isStatic, registerSuperHandler)) {
            annotation = fieldHandler.getAnnotation();
            Field field2 = fieldHandler.getField();
            EventUtils.verify(fieldHandler.getOwner(), annotation, field2);
            for (Class<?> eventClass : EventUtils.getEvents(annotation, field2, eventFilter)) {
                this.registerField(fieldHandler.getOwner(), instance, annotation, field2, eventClass);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMethod(Class<?> owner, @Nullable Object instance, EventHandler annotation, Method method, Class<?> event, boolean virtual) {
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            List handlers = this.handlers.computeIfAbsent(event, key -> this.listSupplier.get());
            AHandler handler = virtual ? this.generator.generateVirtual(owner, instance, annotation, method) : this.generator.generate(owner, instance, annotation, method, event);
            handlers.add(handler);
            this.checkCallChain(event, handlers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerField(Class<?> owner, @Nullable Object instance, EventHandler annotation, Field field, Class<?> event) {
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            AHandler handler;
            List handlers = this.handlers.computeIfAbsent(event, key -> this.listSupplier.get());
            try {
                handler = Runnable.class.isAssignableFrom(field.getType()) ? new RunnableHandler(owner, instance, annotation, (Runnable)field.get(instance)) : new ConsumerHandler(owner, instance, annotation, (Consumer)field.get(instance));
            }
            catch (Throwable t) {
                throw new RuntimeException("Failed to register field '" + field.getName() + "' in class '" + owner.getName() + "'", t);
            }
            handlers.add(handler);
            this.checkCallChain(event, handlers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Class<?> owner) {
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            HashMap checked = new HashMap();
            for (Map.Entry<Class<?>, List<AHandler>> entry : this.handlers.entrySet()) {
                List<AHandler> handlers = entry.getValue();
                handlers.removeIf(handler -> handler.isStatic() && handler.getOwner().equals(owner));
                checked.put(entry.getKey(), handlers);
            }
            for (Map.Entry<Class<Object>, List<AHandler>> entry : checked.entrySet()) {
                this.checkCallChain(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Class<?> event, Class<?> owner) {
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            List<AHandler> handlers = this.handlers.get(event);
            if (handlers == null) {
                return;
            }
            handlers.removeIf(handler -> handler.isStatic() && handler.getOwner().equals(owner));
            this.checkCallChain(event, handlers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Object owner) {
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            HashMap checked = new HashMap();
            for (Map.Entry<Class<?>, List<AHandler>> entry : this.handlers.entrySet()) {
                List<AHandler> handlers = entry.getValue();
                handlers.removeIf(handler -> !handler.isStatic() && owner.equals(handler.getInstance()));
                checked.put(entry.getKey(), handlers);
            }
            for (Map.Entry<Class<Object>, List<AHandler>> entry : checked.entrySet()) {
                this.checkCallChain(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Class<?> event, Object owner) {
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            List<AHandler> handlers = this.handlers.get(event);
            if (handlers == null) {
                return;
            }
            handlers.removeIf(handler -> !handler.isStatic() && owner.equals(handler.getInstance()));
            this.checkCallChain(event, handlers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterRunnable(Runnable runnable) {
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            HashMap checked = new HashMap();
            for (Map.Entry<Class<?>, List<AHandler>> entry : this.handlers.entrySet()) {
                List<AHandler> handlers = entry.getValue();
                handlers.removeIf(handler -> handler instanceof RunnableHandler && ((RunnableHandler)handler).getRunnable().equals(runnable));
                checked.put(entry.getKey(), handlers);
            }
            for (Map.Entry<Class<Object>, List<AHandler>> entry : checked.entrySet()) {
                this.checkCallChain(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterRunnable(Runnable runnable, Class<?> ... events) {
        if (events.length == 0) {
            this.unregisterRunnable(runnable);
            return;
        }
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            for (Class<?> event : events) {
                List<AHandler> handlers = this.handlers.get(event);
                if (handlers == null) continue;
                handlers.removeIf(handler -> handler instanceof RunnableHandler && ((RunnableHandler)handler).getRunnable().equals(runnable));
                this.checkCallChain(event, handlers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConsumer(Consumer<?> consumer) {
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            HashMap checked = new HashMap();
            for (Map.Entry<Class<?>, List<AHandler>> entry : this.handlers.entrySet()) {
                List<AHandler> handlers = entry.getValue();
                handlers.removeIf(handler -> handler instanceof ConsumerHandler && ((ConsumerHandler)handler).getConsumer().equals(consumer));
                checked.put(entry.getKey(), handlers);
            }
            for (Map.Entry<Class<Object>, List<AHandler>> entry : checked.entrySet()) {
                this.checkCallChain(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterConsumer(Consumer<?> consumer, Class<?> ... events) {
        if (events.length == 0) {
            this.unregisterConsumer(consumer);
            return;
        }
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            for (Class<?> event : events) {
                List<AHandler> handlers = this.handlers.get(event);
                if (handlers == null) continue;
                handlers.removeIf(handler -> handler instanceof ConsumerHandler && ((ConsumerHandler)handler).getConsumer().equals(consumer));
                this.checkCallChain(event, handlers);
            }
        }
    }

    @Deprecated
    public void unregister(Runnable runnable) {
        this.unregisterRunnable(runnable);
    }

    @Deprecated
    public void unregister(Runnable runnable, Class<?> ... events) {
        this.unregisterRunnable(runnable, events);
    }

    @Deprecated
    public void unregister(Consumer<?> consumer) {
        this.unregisterConsumer(consumer);
    }

    @Deprecated
    public void unregister(Consumer<?> consumer, Class<?> ... events) {
        this.unregisterConsumer(consumer, events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll(Class<?> event) {
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            this.checkCallChain(event, Collections.emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll(Class<?> event, Predicate<Class<?>> filter) {
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            this.unregisterAll(event, filter, false);
            this.unregisterAll(event, filter, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll(Class<?> event, Predicate<Class<?>> filter, boolean staticHandlers) {
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            List<AHandler> handlers = this.handlers.get(event);
            if (handlers == null) {
                return;
            }
            handlers.removeIf(handler -> {
                if (handler.isStatic() != staticHandlers) {
                    return false;
                }
                return filter.test(handler.getOwner());
            });
            this.checkCallChain(event, handlers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAll(Class<?> event, BiPredicate<Class<?>, Optional<Object>> filter) {
        Map<Class<?>, List<AHandler>> map = this.handlers;
        synchronized (map) {
            List<AHandler> handlers = this.handlers.get(event);
            if (handlers == null) {
                return;
            }
            handlers.removeIf(handler -> filter.test(handler.getOwner(), Optional.ofNullable(handler.getInstance())));
            this.checkCallChain(event, handlers);
        }
    }

    private void checkCallChain(Class<?> event, List<AHandler> handlers) {
        if (handlers.isEmpty()) {
            this.handlers.remove(event);
            this.handlerArrays.remove(event);
            return;
        }
        if (handlers.size() > 1) {
            handlers.sort(Comparator.comparingInt(o -> o.getAnnotation().priority()).reversed());
        }
        this.handlerArrays.put(event, handlers.toArray(new AHandler[0]));
    }

    public String toString() {
        StringBuilder out = new StringBuilder("LambdaManager{\n");
        for (Map.Entry<Class<?>, AHandler[]> entry : this.handlerArrays.entrySet()) {
            out.append("\t").append(entry.getKey().getName()).append("[\n");
            for (AHandler handler : entry.getValue()) {
                out.append("\t\t").append(handler.toString()).append("\n");
            }
            out.append("\t]\n");
        }
        return out.append("}").toString();
    }
}

