/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlight;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.buffers.Std140Builder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import java.nio.ByteBuffer;
import java.util.OptionalInt;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import xaeroplus.feature.render.DrawContext;
import xaeroplus.feature.render.highlight.AbstractHighlightVertexBuffer;
import xaeroplus.feature.render.shaders.XaeroPlusShaders;
import xaeroplus.util.ChunkUtils;
import xaeroplus.util.ColorHelper;

public class HighlightVertexBuffer
extends AbstractHighlightVertexBuffer {
    @Override
    public void preRender(DrawContext ctx, Long2LongMap highlights, int color) {
        super.preRender(ctx, highlights, color);
    }

    @Override
    public void refresh(DrawContext ctx, Long2LongMap highlights, int color) {
        this.stale = false;
        this.lastRefreshed = System.currentTimeMillis();
        this.flipped = ctx.worldmap();
        if (highlights.isEmpty() || ColorHelper.getA(color) == 0.0f) {
            this.close();
            return;
        }
        class_287 bufferBuilder = class_289.method_1348().method_60827(VertexFormat.class_5596.field_27382, class_290.field_1592);
        for (Long highlight : highlights.keySet()) {
            int chunkPosX = ChunkUtils.longToChunkX(highlight);
            int chunkPosZ = ChunkUtils.longToChunkZ(highlight);
            float x1 = chunkPosX;
            float x2 = chunkPosX + 1;
            float y1 = this.flipped ? (float)(chunkPosZ + 1) : (float)chunkPosZ;
            float y2 = this.flipped ? (float)chunkPosZ : (float)(chunkPosZ + 1);
            bufferBuilder.method_22912(x1, y2, 0.0f);
            bufferBuilder.method_22912(x2, y2, 0.0f);
            bufferBuilder.method_22912(x2, y1, 0.0f);
            bufferBuilder.method_22912(x1, y1, 0.0f);
        }
        try (class_9801 meshData = bufferBuilder.method_60800();){
            this.close();
            this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Chunk Highlight Buffer", 32, meshData.method_60818());
            this.indexCount = meshData.method_60822().comp_751();
        }
    }

    @Override
    public void render(DrawContext ctx, Long2LongMap highlights, int color) {
        if (this.vertexBuffer == null || this.vertexBuffer.isClosed() || this.uniformBuffer == null) {
            return;
        }
        float a = ColorHelper.getA(color);
        float r = ColorHelper.getR(color);
        float g = ColorHelper.getG(color);
        float b = ColorHelper.getB(color);
        this.uniformBuffer.method_71121();
        try (GpuBuffer.MappedView mappedView = RenderSystem.getDevice().createCommandEncoder().mapBuffer(this.uniformBuffer.method_71119(), false, true);){
            Std140Builder.intoBuffer((ByteBuffer)mappedView.data()).putMat4f((Matrix4fc)ctx.matrixStack().method_23760().method_23761()).putVec4((Vector4fc)new Vector4f(r, g, b, a));
        }
        GpuBufferSlice dynamic = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
        RenderSystem.class_5590 autoIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)VertexFormat.class_5596.field_27382);
        VertexFormat.class_5595 indexType = autoIndexBuffer.method_31924();
        GpuBuffer indexBuffer = autoIndexBuffer.method_68274(this.indexCount);
        try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "XaeroPlus Highlight Vertex Buffer", class_310.method_1551().method_1522().method_71639(), OptionalInt.empty());){
            pass.setPipeline(XaeroPlusShaders.HIGHLIGHT_PIPELINE);
            RenderSystem.bindDefaultUniforms((RenderPass)pass);
            pass.setUniform("DynamicTransforms", dynamic);
            pass.setUniform("HighlightTransforms", this.uniformBuffer.method_71119());
            pass.setIndexBuffer(indexBuffer, indexType);
            pass.setVertexBuffer(0, this.vertexBuffer);
            pass.drawIndexed(0, 0, this.indexCount, 1);
        }
    }
}

