/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.util;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2397;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3854;
import net.minecraft.class_4002;
import net.minecraft.class_5635;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_703;
import net.minecraft.class_7764;
import net.minecraft.class_777;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.config.LeafSettingsEntry;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.init.Leaves;
import randommcsomethin.fallingleaves.mixin.LeavesBlockAccessor;
import randommcsomethin.fallingleaves.mixin.NativeImageAccessor;
import randommcsomethin.fallingleaves.mixin.ParticleSpriteManagerAccessor;
import randommcsomethin.fallingleaves.mixin.SpriteContentsAccessor;
import randommcsomethin.fallingleaves.particle.ParticleImplementation;
import randommcsomethin.fallingleaves.seasons.Season;
import randommcsomethin.fallingleaves.seasons.Seasons;
import randommcsomethin.fallingleaves.util.TextureCache;

public class LeafUtil {
    public static final class_2960 TINTED_LEAVES_PARTICLE_ID = class_2960.method_60656((String)"tinted_leaves");
    public static final class_2960 CHERRY_LEAVES_PARTICLE_ID = class_2960.method_60656((String)"cherry_leaves");
    public static final class_2960 PALE_OAK_LEAVES_PARTICLE_ID = class_2960.method_60656((String)"pale_oak_leaves");
    private static final class_5819 renderRandom = class_5819.method_43053();

    public static class_4002 getSpriteProvider(class_2960 spriteId) {
        return (class_4002)((ParticleSpriteManagerAccessor)class_310.method_1551().field_1713).getSpriteAwareParticleFactories().get(spriteId);
    }

    public static float getModifiedSpawnChance(class_2338 pos, class_2680 state, LeafSettingsEntry leafSettings) {
        if (LeafUtil.isInsideMinimalSpawnRadius(pos)) {
            return 0.0f;
        }
        if (!Config.CONFIG.dropFromPlayerPlacedBlocks && state.method_28498((class_2769)class_2397.field_11200) && ((Boolean)state.method_11654((class_2769)class_2397.field_11200)).booleanValue()) {
            return 0.0f;
        }
        if (leafSettings == null) {
            return 0.0f;
        }
        float spawnChance = leafSettings.getSpawnChance();
        if (Seasons.currentSeason == Season.FALL) {
            spawnChance *= Config.CONFIG.fallSpawnRateFactor;
        } else if (Seasons.currentSeason == Season.WINTER) {
            spawnChance *= Config.CONFIG.winterSpawnRateFactor;
        }
        if (Config.CONFIG.decaySpawnRateFactor != 1.0f && LeafUtil.isLeafBlock(state.method_26204(), true) && state.method_26229()) {
            spawnChance *= Config.CONFIG.decaySpawnRateFactor;
        }
        return spawnChance;
    }

    private static boolean isInsideMinimalSpawnRadius(class_2338 pos) {
        if (Config.CONFIG.startingSpawnRadius == 0) {
            return false;
        }
        return LeafUtil.getMaximumDistance((class_2382)Objects.requireNonNull(class_310.method_1551().field_1724).method_24515(), (class_2382)pos) < Config.CONFIG.startingSpawnRadius;
    }

    public static void trySpawnSnowParticle(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (LeafUtil.isInsideMinimalSpawnRadius(pos)) {
            return;
        }
        double snowSpawnChance = Config.CONFIG.getSnowflakeSpawnChance();
        if (snowSpawnChance != 0.0 && random.method_43058() < snowSpawnChance) {
            LeafUtil.spawnSnowParticles(1, false, state, world, pos, random);
        }
    }

    public static void spawnLeafParticles(int count, boolean spawnInsideBlock, class_2680 state, class_1937 world, class_2338 pos, class_5819 random, LeafSettingsEntry leafSettings) {
        class_2248 class_22482;
        if (count == 0) {
            return;
        }
        if (leafSettings.getImplementation() == ParticleImplementation.VANILLA && (class_22482 = state.method_26204()) instanceof LeavesBlockAccessor) {
            LeavesBlockAccessor leavesBlock = (LeavesBlockAccessor)class_22482;
            for (int i = 0; i < count; ++i) {
                leavesBlock.callSpawnLeafParticle(world, pos, random);
            }
            return;
        }
        class_2396<class_2388> particleType = switch (leafSettings.getImplementation()) {
            default -> throw new MatchException(null, null);
            case ParticleImplementation.CHERRY -> Leaves.FALLING_CHERRY;
            case ParticleImplementation.CONIFER -> Leaves.FALLING_CONIFER_LEAF;
            case ParticleImplementation.REGULAR -> Leaves.FALLING_LEAF;
            case ParticleImplementation.VANILLA -> Leaves.FALLING_LEAF;
        };
        class_2388 params = new class_2388(particleType, state);
        LeafUtil.spawnParticles(count, params, spawnInsideBlock, state, world, pos, random);
    }

    public static void spawnSnowParticles(int count, boolean spawnInsideBlock, class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        boolean isSummer;
        if (count == 0) {
            return;
        }
        boolean snowy = false;
        boolean snowyVillagers = class_3854.method_16930((class_6880)world.method_23753(pos)) == class_3854.field_17075;
        boolean bl = isSummer = Seasons.currentSeason == Season.SUMMER;
        if (!isSummer && snowyVillagers) {
            snowy = true;
        } else {
            class_2248 topBlock = world.method_8320(world.method_8598(class_2902.class_2903.field_13202, pos).method_10074()).method_26204();
            boolean isSnowLayer = topBlock instanceof class_2488;
            if (isSnowLayer || topBlock == class_2246.field_10491 || topBlock instanceof class_5635) {
                snowy = true;
            }
        }
        if (!snowy) {
            return;
        }
        class_2388 params = new class_2388(Leaves.FALLING_SNOW, state);
        LeafUtil.spawnParticles(count, params, spawnInsideBlock, state, world, pos, random);
    }

    public static void spawnParticles(int count, class_2388 params, boolean spawnInsideBlock, class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            double y;
            double x = (double)pos.method_10263() + random.method_43058();
            double z = (double)pos.method_10260() + random.method_43058();
            if (spawnInsideBlock) {
                y = (double)pos.method_10264() + random.method_43058();
            } else {
                y = (double)pos.method_10264() - (state.method_26225() ? 0.1 : 0.0);
                if (!LeafUtil.hasRoomForLeafParticle(world, pos, x, y, z)) continue;
            }
            LeafUtil.spawnParticle(params, x, y, z, random);
        }
    }

    public static void spawnParticle(class_2388 params, double x, double y, double z, class_5819 random) {
        class_310 client = class_310.method_1551();
        if (Config.CONFIG.registerParticles) {
            client.field_1713.method_3056((class_2394)params, x, y, z, 0.0, 0.0, 0.0);
        } else {
            class_703 particle = Leaves.FACTORIES.get(params.method_10295()).method_3090((class_2394)params, client.field_1687, x, y, z, 0.0, 0.0, 0.0, random);
            client.field_1713.method_3058(particle);
        }
    }

    public static double[] getBlockTextureColor(class_2680 state, class_1937 world, class_2338 pos) {
        class_10889 part;
        List quads;
        class_310 client = class_310.method_1551();
        class_1087 model = client.method_1541().method_3349(state);
        renderRandom.method_43052(state.method_26190(pos));
        List parts = model.method_68512(renderRandom);
        if (parts.size() > 1) {
            FallingLeavesClient.LOGGER.debug("block state {} has {} parts: {}", (Object)state, (Object)parts.size(), (Object)parts);
        }
        class_1058 sprite = null;
        boolean shouldColor = false;
        if (!parts.isEmpty() && !(quads = (part = (class_10889)parts.getFirst()).method_68509(class_2350.field_11033)).isEmpty()) {
            boolean useFirstQuad = true;
            class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
            if (id.method_12836().equals("byg")) {
                useFirstQuad = false;
            }
            class_777 quad = (class_777)quads.get(useFirstQuad ? 0 : quads.size() - 1);
            sprite = quad.comp_3724();
            shouldColor = quad.method_3360();
        }
        if (sprite == null) {
            sprite = model.method_68511();
            shouldColor = true;
        }
        class_7764 spriteContents = sprite.method_45851();
        class_2960 spriteId = spriteContents.method_45816();
        class_1011 texture = ((SpriteContentsAccessor)spriteContents).getMipmapLevelsImages()[0];
        int blockColor = shouldColor ? client.method_1505().method_1697(state, (class_1920)world, pos, 0) : -1;
        return LeafUtil.calculateLeafColor(spriteId, texture, blockColor);
    }

    private static double[] calculateLeafColor(class_2960 spriteId, class_1011 texture, int blockColor) {
        double[] textureColor;
        TextureCache.Data cache = TextureCache.INST.get(spriteId);
        if (cache != null) {
            textureColor = cache.getColor();
        } else {
            textureColor = LeafUtil.averageColor(texture);
            TextureCache.INST.put(spriteId, new TextureCache.Data(textureColor));
            FallingLeavesClient.LOGGER.debug("{}: Calculated texture color {} ", (Object)spriteId, (Object)textureColor);
        }
        if (blockColor != -1) {
            textureColor[0] = textureColor[0] * ((double)(blockColor >> 16 & 0xFF) / 255.0);
            textureColor[1] = textureColor[1] * ((double)(blockColor >> 8 & 0xFF) / 255.0);
            textureColor[2] = textureColor[2] * ((double)(blockColor & 0xFF) / 255.0);
        }
        return textureColor;
    }

    private static boolean hasRoomForLeafParticle(class_1937 world, class_2338 pos, double x, double y, double z) {
        if (LeafUtil.isLeafBlock(world.method_8320(pos.method_10074()).method_26204(), true)) {
            return false;
        }
        double y2 = y - (double)Config.CONFIG.minimumFreeSpaceBelow * 0.5;
        class_238 collisionBox = new class_238(x - 0.1, y, z - 0.1, x + 0.1, y2, z + 0.1);
        return !world.method_20812(null, collisionBox).iterator().hasNext();
    }

    public static Map<class_2960, LeafSettingsEntry> getRegisteredLeafBlocks(boolean useBlockTags) {
        return class_7923.field_41175.method_10235().stream().filter(entry -> LeafUtil.isLeafBlock((class_2248)class_7923.field_41175.method_63535(entry), useBlockTags)).collect(Collectors.toMap(Function.identity(), LeafSettingsEntry::new));
    }

    public static boolean isLeafBlock(class_2248 block, boolean useBlockTags) {
        return block instanceof class_2397 || useBlockTags && block.method_9564().method_26164(class_3481.field_15503);
    }

    @Nullable
    public static LeafSettingsEntry getLeafSettingsEntry(class_2680 blockState) {
        return Config.CONFIG.leafSettings.get(class_7923.field_41175.method_10221((Object)blockState.method_26204()));
    }

    public static int getMaximumDistance(class_2382 v1, class_2382 v2) {
        int dx = Math.abs(v1.method_10263() - v2.method_10263());
        int dy = Math.abs(v1.method_10264() - v2.method_10264());
        int dz = Math.abs(v1.method_10260() - v2.method_10260());
        return Math.max(dx, Math.max(dy, dz));
    }

    public static double[] averageColor(class_1011 image) {
        if (image.method_4318() != class_1011.class_1012.field_4997) {
            FallingLeavesClient.LOGGER.error("RGBA image required, was {}", (Object)image.method_4318());
            return new double[]{1.0, 1.0, 1.0};
        }
        NativeImageAccessor imageAcc = (NativeImageAccessor)image;
        long pointer = imageAcc.getPointer();
        if (pointer == 0L) {
            FallingLeavesClient.LOGGER.error("image is not allocated");
            return new double[]{1.0, 1.0, 1.0};
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int n = 0;
        int width = image.method_4307();
        int height = image.method_4323();
        for (int i = 0; i < width * height; ++i) {
            int c = MemoryUtil.memGetInt((long)(pointer + 4L * (long)i));
            int cr = c & 0xFF;
            int cg = c >> 8 & 0xFF;
            int cb = c >> 16 & 0xFF;
            int ca = c >> 24 & 0xFF;
            if (ca == 0) continue;
            r += (double)cr;
            g += (double)cg;
            b += (double)cb;
            ++n;
        }
        return new double[]{r / (double)n / 255.0, g / (double)n / 255.0, b / (double)n / 255.0};
    }
}

