/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.mixin.sodium;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import me.cortex.nvidium.Nvidium;
import me.cortex.nvidium.NvidiumWorldRenderer;
import me.cortex.nvidium.sodiumCompat.INvidiumWorldRendererGetter;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.caffeinemc.mods.sodium.client.util.FogParameters;
import net.minecraft.class_11658;
import net.minecraft.class_2586;
import net.minecraft.class_3191;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SodiumWorldRenderer.class}, remap=false)
public abstract class MixinSodiumWorldRenderer
implements INvidiumWorldRendererGetter {
    @Shadow
    private RenderSectionManager renderSectionManager;

    @Shadow
    private void extractBlockEntity(class_2586 blockEntity, class_4587 poseStack, class_4184 camera, float tickDelta, Long2ObjectMap<SortedSet<class_3191>> progression, class_11658 levelRenderState) {
    }

    @Inject(method={"setupTerrain"}, at={@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/RenderSectionManager;needsUpdate()Z", shift=At.Shift.BEFORE)})
    private void injectTerrainSetup(class_4184 camera, Viewport viewport, FogParameters fogParameters, boolean spectator, boolean updateChunksImmediately, ChunkRenderMatrices matrices, CallbackInfo ci) {
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs) {
            ((INvidiumWorldRendererGetter)this.renderSectionManager).getRenderer().update(camera, viewport, spectator);
        }
    }

    @Inject(method={"extractBlockEntities(Lnet/minecraft/client/Camera;FLit/unimi/dsi/fastutil/longs/Long2ObjectMap;Lnet/minecraft/client/renderer/state/LevelRenderState;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=true)
    private void overrideEntityRenderer(class_4184 camera, float tickDelta, Long2ObjectMap<SortedSet<class_3191>> progression, class_11658 levelRenderState, CallbackInfo ci) {
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs) {
            ci.cancel();
            class_4587 stack = new class_4587();
            List<RenderSection> sectionsWithEntities = ((INvidiumWorldRendererGetter)this.renderSectionManager).getRenderer().getSectionsWithEntities();
            for (RenderSection section : sectionsWithEntities) {
                if (section.isDisposed() || section.getCulledBlockEntities() == null) continue;
                for (class_2586 entity : section.getCulledBlockEntities()) {
                    this.extractBlockEntity(entity, stack, camera, tickDelta, progression, levelRenderState);
                }
            }
            Collection sectionsWithGlobalEntities = this.renderSectionManager.getSectionsWithGlobalEntities();
            for (RenderSection section : sectionsWithGlobalEntities) {
                if (section.isDisposed() || section.getGlobalBlockEntities() == null) continue;
                for (class_2586 entity : section.getGlobalBlockEntities()) {
                    this.extractBlockEntity(entity, stack, camera, tickDelta, progression, levelRenderState);
                }
            }
        }
    }

    @Override
    public NvidiumWorldRenderer getRenderer() {
        if (Nvidium.IS_ENABLED) {
            return ((INvidiumWorldRendererGetter)this.renderSectionManager).getRenderer();
        }
        return null;
    }
}

