/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.renderers;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.textures.GpuTextureView;
import me.cortex.nvidium.gl.shader.Shader;
import me.cortex.nvidium.gl.shader.ShaderType;
import me.cortex.nvidium.renderers.Phase;
import me.cortex.nvidium.sodiumCompat.ShaderLoader;
import me.cortex.nvidium.util.GPUTiming;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.minecraft.class_10868;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GL45;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengl.NVMeshShader;
import org.lwjgl.opengl.NVVertexBufferUnifiedMemory;

public class PrimaryTerrainRasterizer
extends Phase {
    private final int blockSampler = GL33.glGenSamplers();
    private final int lightSampler = GL33.glGenSamplers();
    private final Shader shader = Shader.make().addSource(ShaderType.TASK, ShaderLoader.parse(class_2960.method_60655((String)"nvidium", (String)"terrain/task.glsl"))).addSource(ShaderType.MESH, ShaderLoader.parse(class_2960.method_60655((String)"nvidium", (String)"terrain/mesh.glsl"))).addSource(ShaderType.FRAGMENT, ShaderLoader.parse(class_2960.method_60655((String)"nvidium", (String)"terrain/frag.frag"))).compile();

    public PrimaryTerrainRasterizer() {
        GL45C.glSamplerParameteri((int)this.blockSampler, (int)10241, (int)9986);
        GL45C.glSamplerParameteri((int)this.blockSampler, (int)10240, (int)9728);
        GL45C.glSamplerParameteri((int)this.blockSampler, (int)33082, (int)0);
        GL45C.glSamplerParameteri((int)this.blockSampler, (int)33083, (int)4);
        GL45C.glSamplerParameteri((int)this.lightSampler, (int)10243, (int)33071);
        GL45C.glSamplerParameteri((int)this.lightSampler, (int)10242, (int)33071);
        GL45C.glSamplerParameteri((int)this.lightSampler, (int)10241, (int)9729);
        GL45C.glSamplerParameteri((int)this.lightSampler, (int)10240, (int)9729);
    }

    private static void setTexture(GpuTextureView texView, int bindingPoint) {
        class_10868 tex = (class_10868)texView.texture();
        GlStateManager._activeTexture((int)(33984 + bindingPoint));
        GlStateManager._bindTexture((int)tex.method_68427());
        GlStateManager._texParameter((int)3553, (int)33084, (int)texView.baseMipLevel());
        GlStateManager._texParameter((int)3553, (int)33085, (int)(texView.baseMipLevel() + texView.mipLevels() - 1));
        tex.method_68424(3553);
    }

    public void raster(TerrainRenderPass pass, int regionCount, long commandAddr, GPUTiming gpuTiming) {
        this.shader.bind();
        GpuTextureView blockTexture = pass.getAtlas();
        GpuTextureView lightTexture = class_310.method_1551().field_1773.method_22974().method_71650();
        GL45C.glBindSampler((int)0, (int)this.blockSampler);
        GL45C.glBindSampler((int)1, (int)this.lightSampler);
        PrimaryTerrainRasterizer.setTexture(blockTexture, 0);
        PrimaryTerrainRasterizer.setTexture(lightTexture, 1);
        NVVertexBufferUnifiedMemory.glBufferAddressRangeNV((int)36673, (int)0, (long)commandAddr, (long)((long)regionCount * 8L));
        gpuTiming.marker();
        NVMeshShader.glMultiDrawMeshTasksIndirectNV((long)0L, (int)regionCount, (int)0);
        gpuTiming.marker();
        gpuTiming.tick();
        GL45C.glBindSampler((int)0, (int)0);
        GL45C.glBindSampler((int)1, (int)0);
    }

    public void delete() {
        GL45.glDeleteSamplers((int)this.blockSampler);
        GL45.glDeleteSamplers((int)this.lightSampler);
        this.shader.delete();
    }
}

