/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.sodiumCompat;

import net.caffeinemc.mods.sodium.api.util.ColorABGR;
import net.caffeinemc.mods.sodium.api.util.ColorU8;
import net.caffeinemc.mods.sodium.client.gl.attribute.GlVertexFormat;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.minecraft.class_3532;
import org.lwjgl.system.MemoryUtil;

public class NvidiumCompactChunkVertex
implements ChunkVertexType {
    public static final GlVertexFormat VERTEX_FORMAT = new GlVertexFormat(null, null, 16);
    public static final int STRIDE = 16;
    public static final NvidiumCompactChunkVertex INSTANCE = new NvidiumCompactChunkVertex();
    private static final int POSITION_MAX_VALUE = 65536;
    public static final int TEXTURE_MAX_VALUE = 32768;
    private static final float MODEL_ORIGIN = 8.0f;
    private static final float MODEL_RANGE = 32.0f;
    private static final float MODEL_SCALE = 4.8828125E-4f;
    private static final float MODEL_SCALE_INV = 2048.0f;
    private static final float TEXTURE_SCALE = 3.0517578E-5f;

    public GlVertexFormat getVertexFormat() {
        return VERTEX_FORMAT;
    }

    public ChunkVertexEncoder getEncoder() {
        return (ptr, material, vertices, sectionIndex) -> {
            for (ChunkVertexEncoder.Vertex vertex : vertices) {
                int light = NvidiumCompactChunkVertex.compactLight(vertex.light);
                MemoryUtil.memPutInt((long)(ptr + 0L), (int)(NvidiumCompactChunkVertex.encodePosition(vertex.x) << 0 | NvidiumCompactChunkVertex.encodePosition(vertex.y) << 16));
                MemoryUtil.memPutInt((long)(ptr + 4L), (int)(NvidiumCompactChunkVertex.encodePosition(vertex.z) << 0 | NvidiumCompactChunkVertex.encodeDrawParameters(material) << 16 | (light & 0xFF) << 24));
                MemoryUtil.memPutInt((long)(ptr + 8L), (int)(NvidiumCompactChunkVertex.encodeColor(vertex.color, vertex.ao) << 0 | (light >> 8 & 0xFF) << 24));
                MemoryUtil.memPutInt((long)(ptr + 12L), (int)NvidiumCompactChunkVertex.encodeTexture(vertex.u, vertex.v));
                ptr += 16L;
            }
            return ptr;
        };
    }

    private static int compactLight(int light) {
        int sky = class_3532.method_15340((int)(light >>> 16 & 0xFF), (int)8, (int)248);
        int block = class_3532.method_15340((int)(light >>> 0 & 0xFF), (int)8, (int)248);
        return block << 0 | sky << 8;
    }

    private static int encodePosition(float v) {
        return (int)((8.0f + v) / 32.0f * 65536.0f);
    }

    private static int encodeDrawParameters(int material) {
        return (material & 0xFF) << 0;
    }

    private static int encodeColor(int color, float brightness) {
        int r = ColorU8.normalizedFloatToByte((float)(ColorU8.byteToNormalizedFloat((int)ColorABGR.unpackRed((int)color)) * brightness));
        int g = ColorU8.normalizedFloatToByte((float)(ColorU8.byteToNormalizedFloat((int)ColorABGR.unpackGreen((int)color)) * brightness));
        int b = ColorU8.normalizedFloatToByte((float)(ColorU8.byteToNormalizedFloat((int)ColorABGR.unpackBlue((int)color)) * brightness));
        return ColorABGR.pack((int)r, (int)g, (int)b, (int)0);
    }

    private static int encodeTexture(float u, float v) {
        return (Math.round(u * 32768.0f) & 0xFFFF) << 0 | (Math.round(v * 32768.0f) & 0xFFFF) << 16;
    }
}

