/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.volume.VolumeEntry;
import de.maxhenkel.voicechat.plugins.impl.VolumeCategoryImpl;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class CategoryVolumeEntry
extends VolumeEntry {
    protected final VolumeCategoryImpl category;
    protected final class_2960 texture;

    public CategoryVolumeEntry(VolumeCategoryImpl category, AdjustVolumesScreen screen) {
        super(screen, new AdjustCategoryVolumeEntry(category.getId()));
        this.category = category;
        this.texture = ClientManager.getCategoryManager().getTexture(category.getId(), OTHER_VOLUME_ICON);
    }

    public VolumeCategoryImpl getCategory() {
        return this.category;
    }

    @Override
    public void renderElement(class_332 guiGraphics, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta, int skinX, int skinY, int textX, int textY) {
        guiGraphics.method_25302(class_10799.field_56883, this.texture, skinX, skinY, 16.0f, 16.0f, 24, 24, 16, 16, 16, 16);
        guiGraphics.method_51439(this.minecraft.field_1772, this.category.getDisplayName(), textX, textY, PLAYER_NAME_COLOR, false);
        if (hovered && this.category.getDescription() != null) {
            this.screen.postRender(() -> guiGraphics.method_51438(this.minecraft.field_1772, this.category.getDisplayDescription(), mouseX, mouseY));
        }
    }

    private static class AdjustCategoryVolumeEntry
    implements AdjustVolumeSlider.AdjustVolumeEntry {
        private final String category;

        public AdjustCategoryVolumeEntry(String category) {
            this.category = category;
        }

        @Override
        public void save(double value) {
            VoicechatClient.CATEGORY_VOLUME_CONFIG.setVolume(this.category, value, new String[0]);
            VoicechatClient.CATEGORY_VOLUME_CONFIG.save();
        }

        @Override
        public double get() {
            return VoicechatClient.CATEGORY_VOLUME_CONFIG.getVolume(this.category);
        }

        @Override
        public double getAudioLevel() {
            ClientVoicechat client = ClientManager.getClient();
            if (client == null) {
                return -127.0;
            }
            return client.getTalkCache().getCategoryAudioLevel(this.category);
        }
    }
}

