/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.impl.client;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.ProcessingDataKey;
import me.pepperbell.continuity.api.client.ProcessingDataKeyRegistry;
import me.pepperbell.continuity.impl.client.ProcessingDataKeyImpl;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class ProcessingDataKeyRegistryImpl
implements ProcessingDataKeyRegistry {
    public static final ProcessingDataKeyRegistryImpl INSTANCE = new ProcessingDataKeyRegistryImpl();
    private final Map<class_2960, ProcessingDataKey<?>> keyMap = new Object2ObjectOpenHashMap();
    private final List<ProcessingDataKey<?>> allResettable = new ObjectArrayList();
    private final List<ProcessingDataKey<?>> allResettableView = Collections.unmodifiableList(this.allResettable);
    private int registeredAmount = 0;
    private boolean frozen;

    @Override
    public <T> ProcessingDataKey<T> registerKey(class_2960 id, Supplier<T> valueSupplier, Consumer<T> valueResetAction) {
        if (this.frozen) {
            throw new IllegalArgumentException("Cannot register processing data key for ID '" + String.valueOf(id) + "' to frozen registry");
        }
        ProcessingDataKey<?> oldKey = this.keyMap.get(id);
        if (oldKey != null) {
            throw new IllegalArgumentException("Cannot override processing data key registration for ID '" + String.valueOf(id) + "'");
        }
        ProcessingDataKeyImpl<T> key = new ProcessingDataKeyImpl<T>(id, this.registeredAmount, valueSupplier, valueResetAction);
        this.keyMap.put(id, key);
        if (valueResetAction != null) {
            this.allResettable.add(key);
        }
        ++this.registeredAmount;
        return key;
    }

    @Override
    @Nullable
    public ProcessingDataKey<?> getKey(class_2960 id) {
        return this.keyMap.get(id);
    }

    @Override
    public int getRegisteredAmount() {
        return this.registeredAmount;
    }

    public void init() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            this.frozen = true;
        });
    }

    public List<ProcessingDataKey<?>> getAllResettable() {
        return this.allResettableView;
    }
}

