/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.debugify.mixinplugin;

import dev.isxander.debugify.fixes.BugFix;
import dev.isxander.debugify.fixes.BugFixData;
import dev.isxander.debugify.fixes.FixCategory;
import dev.isxander.debugify.fixes.OS;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class BugFixDataCache {
    private static final Map<String, ResolvedBugFixData> bugFixDataByMixinClass = new HashMap<String, ResolvedBugFixData>();

    static Optional<BugFixData> getOrResolve(String mixinClassName) {
        return Optional.ofNullable(bugFixDataByMixinClass.computeIfAbsent(mixinClassName, BugFixDataCache::resolve).data());
    }

    static Optional<BugFixData> getIfResolved(String mixinClassName) {
        return Optional.ofNullable(bugFixDataByMixinClass.get(mixinClassName)).flatMap(resolved -> Optional.ofNullable(resolved.data()));
    }

    private static ResolvedBugFixData resolve(String mixinClassName) {
        ClassNode classNode = BugFixDataCache.getClassNode(mixinClassName);
        if (classNode == null) {
            return new ResolvedBugFixData(null);
        }
        AnnotationNode annotationNode = Annotations.getVisible((ClassNode)classNode, BugFix.class);
        if (annotationNode == null) {
            return new ResolvedBugFixData(null);
        }
        String id = (String)Annotations.getValue((AnnotationNode)annotationNode, (String)"id");
        FixCategory category = BugFixDataCache.getAnnotationEnumValue(annotationNode, "category", FixCategory.class);
        BugFix.Env env = BugFixDataCache.getAnnotationEnumValue(annotationNode, "env", BugFix.Env.class);
        boolean enabledByDefault = (Boolean)Annotations.getValue((AnnotationNode)annotationNode, (String)"enabled", (Object)true);
        List conflicts = Annotations.getValue((AnnotationNode)annotationNode, (String)"modConflicts", (boolean)true);
        OS requiredOS = (OS)Annotations.getValue((AnnotationNode)annotationNode, (String)"os", OS.class, (Enum)OS.UNKNOWN);
        String description = (String)Annotations.getValue((AnnotationNode)annotationNode, (String)"description");
        if ("".equals(description)) {
            description = null;
        }
        return new ResolvedBugFixData(new BugFixData(id, category, env, enabledByDefault, conflicts, requiredOS, description));
    }

    private static ClassNode getClassNode(String className) {
        try {
            return MixinService.getService().getBytecodeProvider().getClassNode(className);
        }
        catch (IOException | ClassNotFoundException e) {
            return null;
        }
    }

    private static <T extends Enum<T>> T getAnnotationEnumValue(AnnotationNode annotation, String key, Class<T> enumClass) {
        String[] value = (String[])Annotations.getValue((AnnotationNode)annotation, (String)key);
        return Enum.valueOf(enumClass, value[1]);
    }

    record ResolvedBugFixData(@Nullable BugFixData data) {
    }
}

