/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features.methods;

import java.util.List;
import java.util.Map;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_sound_features.ESF;
import traben.entity_sound_features.ESFConfig;

public class ESFIsPlayingSoundMethodFactory
extends MathMethod {
    public ESFIsPlayingSoundMethodFactory(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        boolean log = ((ESFConfig)ESF.config().getConfig()).logSoundSetup;
        if (log) {
            ESF.log("creating sound EMF math function definition (no guaranteed failure log messages unless you enable EMF math logging):\n > " + String.valueOf(args));
        }
        try {
            String soundId = args.get(0);
            if (soundId == null || soundId.isBlank()) {
                throw new EMFMathException("Sound event ID invalid");
            }
            class_2960 test = ESF.res(soundId);
            this.setSupplierAndOptimize(() -> {
                class_2960 res;
                class_1140 engine = class_310.method_1551().method_1483().field_5590;
                if (!engine.field_5563) {
                    return Float.NEGATIVE_INFINITY;
                }
                boolean found = false;
                for (Map.Entry entry : engine.field_18952.entrySet()) {
                    if ((Integer)entry.getValue() > engine.field_5550 || !(res = ((class_1113)entry.getKey()).method_4775()).equals((Object)test)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (class_1113 class_11132 : engine.field_18950.keySet()) {
                        res = class_11132.method_4775();
                        if (!res.equals((Object)test)) continue;
                        found = true;
                        break;
                    }
                }
                return MathValue.fromBoolean((boolean)found);
            });
            if (log) {
                ESF.log("sound EMF math function definition created successfully for " + String.valueOf(test));
            }
        }
        catch (Exception e) {
            if (log) {
                ESF.log("Error creating sound EMF math function definition: " + e.getMessage());
            }
            throw new EMFMathException("Error in playingsound() function: " + e.getMessage());
        }
    }

    protected boolean canOptimizeForConstantArgs() {
        return false;
    }

    protected boolean hasCorrectArgCount(int argCount) {
        return argCount == 1;
    }
}

