/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel.menu;

import com.google.common.annotations.Beta;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.menu.TMenuPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.menu.item.TMenuPanelButton;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.event.handler.TElementEvent_Runnable;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.event.TEvent;
import io.github.thecsdev.tcdcommons.api.event.TEventFactory;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.awt.Color;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TContextMenuPanel
extends TMenuPanel {
    protected final TElement target;
    protected final int initWidh;
    protected final int initHeight;
    @Beta
    @Nullable
    private TContextMenuPanel parentContextMenu;
    @Beta
    @Nullable
    private TContextMenuPanel childContextMenu;
    public final TEvent<TElementEvent_Runnable<TContextMenuPanel>> eOpened = TEventFactory.createLoop(new TElementEvent_Runnable[0]);
    public final TEvent<TElementEvent_Runnable<TContextMenuPanel>> eClosed = TEventFactory.createLoop(new TElementEvent_Runnable[0]);
    protected final TElement.TElementEvent_ParentChanged ehParentChanged = (self, oldP, newP) -> {
        if (newP != null) {
            if (this.getParentTScreen() == null) {
                throw new IllegalStateException("No parent screen? This shouldn't even happen.");
            }
            this.realignPositionToTarget();
            TContextMenuPanel otherContextMenu = (TContextMenuPanel)this.getParentTScreen().findChild(c -> c instanceof TContextMenuPanel && c != this && c != this.parentContextMenu, true);
            if (otherContextMenu != null) {
                otherContextMenu.close();
            }
            this.getParentTScreen().setFocusedElement(this, false);
            this.eOpened.invoker().invoke(this);
        } else {
            this.eClosed.invoker().invoke(this);
        }
    };

    public TContextMenuPanel(TElement target) {
        super(0, 0, Math.max(target.getWidth(), 100), 5);
        this.backgroundColor = Color.BLACK.getRGB();
        this.scrollFlags = 4;
        this.zOffset = 300.0f;
        this.initWidh = this.width;
        this.initHeight = this.height;
        this.target = Objects.requireNonNull(target);
        this.eParentChanged.register(this.ehParentChanged);
        if (target.getParent() instanceof TContextMenuPanel) {
            this.parentContextMenu = (TContextMenuPanel)target.getParent();
            this.parentContextMenu.childContextMenu = this;
            this.parentContextMenu.eClosed.register(parentCM -> this.close());
        } else {
            this.parentContextMenu = null;
        }
        this.target.eContextMenu.invoker().invoke(this.target, this);
    }

    public final TElement getTarget() {
        return this.target;
    }

    @Override
    public final boolean canBeAddedTo(TParentElement futureParent) {
        return futureParent instanceof TScreen;
    }

    @Override
    @Virtual
    public TMenuPanelButton addButton(class_2561 text, Consumer<TButtonWidget> onClick) {
        TMenuPanelButton item = super.addButton(text, onClick);
        item.eClicked.register(btn -> this.close());
        return item;
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext, TInputContext.InputDiscoveryPhase inputPhase) {
        if (super.input(inputContext, inputPhase)) {
            return true;
        }
        if (inputPhase != TInputContext.InputDiscoveryPhase.PREEMPT) {
            return false;
        }
        if (inputContext.getInputType() == TInputContext.InputType.MOUSE_PRESS) {
            TContextMenuPanel h = TContextMenuPanel.findHoveredContextMenu(this.getParentTScreen());
            if (h != this) {
                this.close();
                return true;
            }
        } else if (inputContext.getInputType() == TInputContext.InputType.KEY_PRESS && inputContext.getKeyboardKey().keyCode == 256) {
            this.close();
            return true;
        }
        return false;
    }

    public final boolean open() {
        if (this.isOpen() || this.target.getParentTScreen() == null) {
            return false;
        }
        return this.target.getParentTScreen().addChild(this, false);
    }

    public final boolean close() {
        if (!this.isOpen()) {
            return false;
        }
        return this.getParent().removeChild(this, false);
    }

    public final boolean isOpen() {
        return this.getParent() != null;
    }

    public final boolean closeIfNotFocused() {
        TScreen pts = this.getParentTScreen();
        if (pts == null) {
            return false;
        }
        TElement fe = pts.getFocusedElement();
        if (fe == null || fe != this && fe.findParent(p -> p == this) == null) {
            this.close();
            return true;
        }
        return false;
    }

    @Virtual
    protected void realignPositionToTarget() {
        int newX = this.target.getX();
        int newY = this.target.getEndY();
        if (this.getParentTScreen() != null) {
            int screenWidth = this.getParentTScreen().getWidth();
            int screenHeight = this.getParentTScreen().getHeight();
            if (newX + this.width > screenWidth) {
                newX -= this.width - this.target.getWidth();
            }
            if (newY + this.height > screenHeight) {
                newY -= this.height + this.target.getHeight();
            }
        }
        this.setPosition(newX, newY, false);
    }

    @Override
    public final void onRealignChildren() {
        if (this.eParentChanged.isRegistered(this.ehParentChanged)) {
            this.eParentChanged.register(this.ehParentChanged);
        }
        int sp = this.scrollPadding;
        int sp2 = sp * 2;
        this.width = this.initWidh;
        this.height = this.initHeight - sp;
        TScreen scHalfWHScreen = this.getParentTScreen() != null ? this.getParentTScreen() : this.target.getParentTScreen();
        int scHalfWidth = scHalfWHScreen != null ? scHalfWHScreen.getWidth() / 3 : this.initWidh;
        int scHalfHeight = scHalfWHScreen != null ? scHalfWHScreen.getHeight() / 3 : 100;
        TElement previous = null;
        for (TElement child : this.getChildren()) {
            int nextX = this.getX() + sp;
            int nextY = this.getY() + sp;
            if (previous != null) {
                nextX = previous.getX();
                nextY = previous.getEndY();
            }
            child.setPosition(nextX, nextY, false);
            if (this.width - sp2 < child.getWidth()) {
                this.width = Math.min(scHalfWidth, child.getWidth() + sp2);
            }
            if (this.height < scHalfHeight) {
                this.height += child.getHeight();
            }
            previous = child;
        }
        int gwMsp2 = this.getWidth() - sp2;
        for (TElement child : this.getChildren()) {
            child.setSize(gwMsp2, child.getHeight());
        }
        --this.height;
        this.setSize(this.width, this.height + 1, 7);
    }

    @Nullable
    public static TContextMenuPanel findHoveredContextMenu(TScreen targetScreen) {
        if (targetScreen == null) {
            return null;
        }
        TElement hovered = targetScreen.getHoveredElement();
        if (hovered == null) {
            return null;
        }
        if (hovered instanceof TContextMenuPanel) {
            return (TContextMenuPanel)hovered;
        }
        return (TContextMenuPanel)hovered.findParent(c -> c instanceof TContextMenuPanel);
    }

    public static boolean tryCloseAContextMenu(TScreen targetScreen) {
        if (targetScreen == null) {
            return false;
        }
        TContextMenuPanel cp = (TContextMenuPanel)targetScreen.findChild(c -> c instanceof TContextMenuPanel, true);
        if (cp != null) {
            cp.close();
            return true;
        }
        return false;
    }
}

