/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.io;

import com.google.gson.JsonElement;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.TCDCommonsConfig;
import io.github.thecsdev.tcdcommons.api.util.annotations.CallerSensitive;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)(TCDCommons.getModID() + ":" + HttpUtils.class.getSimpleName().toLowerCase()));
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

    private HttpUtils() {
    }

    @Deprecated(since="v3.12", forRemoval=true)
    @CallerSensitive
    public static final String httpGetSyncS(URI endpoint, Header ... httpHeaders) throws UnsupportedOperationException, NullPointerException, IOException {
        return HttpUtils.httpGetSync(String.class, STACK_WALKER.getCallerClass(), endpoint, httpHeaders);
    }

    @Deprecated(since="v3.12", forRemoval=true)
    @CallerSensitive
    public static final byte[] httpGetSyncB(URI endpoint, Header ... httpHeaders) throws UnsupportedOperationException, NullPointerException, IOException {
        return HttpUtils.httpGetSync(byte[].class, STACK_WALKER.getCallerClass(), endpoint, httpHeaders);
    }

    @Deprecated(since="v3.12", forRemoval=true)
    @ApiStatus.Internal
    private static final <T> T httpGetSync(Class<T> requestedType, Class<?> requestee, URI endpoint, Header ... httpHeaders) throws UnsupportedOperationException, NullPointerException, IOException {
        block7: {
            HttpEntity responseEntity;
            AtomicBoolean success;
            CloseableHttpClient httpClient;
            String requesteeName;
            block6: {
                String string;
                HttpUtils.assertEnabled();
                requesteeName = requestee.getName();
                HttpGet httpGet = new HttpGet(Objects.requireNonNull(endpoint));
                for (Header header : Objects.requireNonNull(httpHeaders)) {
                    httpGet.addHeader(Objects.requireNonNull(header));
                }
                httpGet.addHeader("User-Agent", TCDCommons.getInstance().userAgent);
                httpGet.addHeader("x-" + TCDCommons.getModID() + "-requestee", requesteeName);
                RequestConfig reqConfig = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(3000).setSocketTimeout(10000).build();
                httpClient = HttpClients.custom().setDefaultRequestConfig(reqConfig).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy()).build();
                success = new AtomicBoolean(false);
                try {
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                    responseEntity = response.getEntity();
                    StatusLine responseSL = response.getStatusLine();
                    if (responseSL.getStatusCode() != 200) {
                        throw new HttpResponseException(responseSL.getStatusCode(), responseSL.getReasonPhrase());
                    }
                    success.set(true);
                    if (!Objects.equals(requestedType, String.class)) break block6;
                    string = EntityUtils.toString((HttpEntity)responseEntity);
                }
                catch (Throwable throwable) {
                    LOGGER.info(String.format("HTTP GET '%s'; Requested by '%s'; Success '%s'.", endpoint.toString(), requesteeName, Boolean.toString(success.get())));
                    HttpClientUtils.closeQuietly((HttpClient)httpClient);
                    throw throwable;
                }
                LOGGER.info(String.format("HTTP GET '%s'; Requested by '%s'; Success '%s'.", endpoint.toString(), requesteeName, Boolean.toString(success.get())));
                HttpClientUtils.closeQuietly((HttpClient)httpClient);
                return (T)string;
            }
            if (!Objects.equals(requestedType, byte[].class)) break block7;
            byte[] byArray = EntityUtils.toByteArray((HttpEntity)responseEntity);
            LOGGER.info(String.format("HTTP GET '%s'; Requested by '%s'; Success '%s'.", endpoint.toString(), requesteeName, Boolean.toString(success.get())));
            HttpClientUtils.closeQuietly((HttpClient)httpClient);
            return (T)byArray;
        }
        throw new UnsupportedOperationException("Unsupported resource type '" + String.valueOf(requestedType) + "'; Also you're wasting bandwidth and RAM because of this!");
    }

    public static final boolean isEnabled() {
        TCDCommons tcdc = TCDCommons.getInstance();
        if (tcdc == null) {
            return false;
        }
        return tcdc.getConfig().enableHttpUtils;
    }

    @ApiStatus.Internal
    private static final void assertEnabled() throws UnsupportedOperationException {
        TCDCommons tcdc = TCDCommons.getInstance();
        if (tcdc == null) {
            throw new UnsupportedOperationException("API not initialized yet.");
        }
        if (!tcdc.getConfig().enableHttpUtils) {
            throw new UnsupportedOperationException(String.format("%s has been disabled via the '%s' config file.", HttpUtils.class.getSimpleName(), TCDCommons.getModID()));
        }
    }

    public static final CloseableHttpResponse fetchSync(String url) throws NullPointerException, UnsupportedOperationException, URISyntaxException, ClientProtocolException, IOException {
        return HttpUtils.fetch(url, new FetchOptions(){}, STACK_WALKER.getCallerClass());
    }

    @CallerSensitive
    public static final CloseableHttpResponse fetchSync(String url, FetchOptions options) throws NullPointerException, UnsupportedOperationException, URISyntaxException, ClientProtocolException, IOException {
        return HttpUtils.fetch(url, options, STACK_WALKER.getCallerClass());
    }

    private static final CloseableHttpResponse fetch(String url, FetchOptions options, Class<?> requestee) throws NullPointerException, UnsupportedOperationException, URISyntaxException, ClientProtocolException, IOException {
        long contentLength;
        String method;
        HttpUtils.assertEnabled();
        Objects.requireNonNull(url);
        Objects.requireNonNull(options);
        String httpMethod = options.method();
        Objects.requireNonNull(httpMethod);
        CloseableHttpResponse result = switch (method = httpMethod.toUpperCase(Locale.ENGLISH).trim()) {
            case "GET" -> HttpUtils.fetch_get(url, options, requestee);
            case "HEAD" -> HttpUtils.fetch_head(url, options, requestee);
            case "POST" -> HttpUtils.fetch_post(url, options, requestee);
            case "PUT" -> HttpUtils.fetch_put(url, options, requestee);
            case "DELETE" -> HttpUtils.fetch_delete(url, options, requestee);
            case "OPTIONS" -> HttpUtils.fetch_options(url, options, requestee);
            case "TRACE" -> HttpUtils.fetch_trace(url, options, requestee);
            case "PATCH" -> HttpUtils.fetch_patch(url, options, requestee);
            default -> throw new UnsupportedOperationException("HTTP " + httpMethod);
        };
        long l = contentLength = result.getEntity() != null ? result.getEntity().getContentLength() : 0L;
        if (TCDCommonsConfig.DEV_ENV) {
            LOGGER.info("HTTP " + method + " " + url + " | Response: HTTP " + result.getStatusLine().getStatusCode() + " " + result.getStatusLine().getReasonPhrase() + " | Content-Length: " + contentLength + " | Requested by: " + requestee.getName());
        }
        if (contentLength > 100000000L) {
            IOUtils.closeQuietly((Closeable)result);
            throw new IOException("Response 'Content-Length' is too large!");
        }
        return result;
    }

    private static final CloseableHttpResponse fetch_get(String url, FetchOptions options, Class<?> requestee) throws URISyntaxException, ClientProtocolException, IOException {
        if (options.body() != null) {
            throw new UnsupportedOperationException("HTTP GET does not support having a request body.");
        }
        CloseableHttpClient client = HttpClients.createDefault();
        HttpGet request = new HttpGet(new URI(url));
        HttpUtils.fetch_setHeaders((AbstractHttpMessage)request, options, requestee);
        return client.execute((HttpUriRequest)request);
    }

    private static final CloseableHttpResponse fetch_head(String url, FetchOptions options, Class<?> requestee) throws URISyntaxException, ClientProtocolException, IOException {
        if (options.body() != null) {
            throw new UnsupportedOperationException("HTTP HEAD does not support having a request body.");
        }
        CloseableHttpClient client = HttpClients.createDefault();
        HttpHead request = new HttpHead(new URI(url));
        HttpUtils.fetch_setHeaders((AbstractHttpMessage)request, options, requestee);
        return client.execute((HttpUriRequest)request);
    }

    private static final CloseableHttpResponse fetch_post(String url, FetchOptions options, Class<?> requestee) throws URISyntaxException, ClientProtocolException, IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost request = new HttpPost(new URI(url));
        HttpUtils.fetch_setHeaders((AbstractHttpMessage)request, options, requestee);
        HttpEntity body = HttpUtils.fetch_bodyToEntity(options.body());
        if (body != null) {
            request.setEntity(body);
        }
        return client.execute((HttpUriRequest)request);
    }

    private static final CloseableHttpResponse fetch_put(String url, FetchOptions options, Class<?> requestee) throws URISyntaxException, ClientProtocolException, IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPut request = new HttpPut(new URI(url));
        HttpUtils.fetch_setHeaders((AbstractHttpMessage)request, options, requestee);
        HttpEntity body = HttpUtils.fetch_bodyToEntity(options.body());
        if (body != null) {
            request.setEntity(body);
        }
        return client.execute((HttpUriRequest)request);
    }

    private static final CloseableHttpResponse fetch_delete(String url, FetchOptions options, Class<?> requestee) throws URISyntaxException, ClientProtocolException, IOException {
        if (options.body() != null) {
            throw new UnsupportedOperationException("HTTP DELETE does not support having a request body.");
        }
        CloseableHttpClient client = HttpClients.createDefault();
        HttpDelete request = new HttpDelete(new URI(url));
        HttpUtils.fetch_setHeaders((AbstractHttpMessage)request, options, requestee);
        return client.execute((HttpUriRequest)request);
    }

    private static final CloseableHttpResponse fetch_options(String url, FetchOptions options, Class<?> requestee) throws URISyntaxException, ClientProtocolException, IOException {
        if (options.body() != null) {
            throw new UnsupportedOperationException("HTTP OPTIONS does not support having a request body.");
        }
        CloseableHttpClient client = HttpClients.createDefault();
        HttpOptions request = new HttpOptions(new URI(url));
        HttpUtils.fetch_setHeaders((AbstractHttpMessage)request, options, requestee);
        return client.execute((HttpUriRequest)request);
    }

    private static final CloseableHttpResponse fetch_trace(String url, FetchOptions options, Class<?> requestee) throws URISyntaxException, ClientProtocolException, IOException {
        if (options.body() != null) {
            throw new UnsupportedOperationException("HTTP TRACE does not support having a request body.");
        }
        CloseableHttpClient client = HttpClients.createDefault();
        HttpTrace request = new HttpTrace(new URI(url));
        HttpUtils.fetch_setHeaders((AbstractHttpMessage)request, options, requestee);
        return client.execute((HttpUriRequest)request);
    }

    private static final CloseableHttpResponse fetch_patch(String url, FetchOptions options, Class<?> requestee) throws URISyntaxException, ClientProtocolException, IOException {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPatch request = new HttpPatch(new URI(url));
        HttpUtils.fetch_setHeaders((AbstractHttpMessage)request, options, requestee);
        HttpEntity body = HttpUtils.fetch_bodyToEntity(options.body());
        if (body != null) {
            request.setEntity(body);
        }
        return client.execute((HttpUriRequest)request);
    }

    private static final void fetch_setHeaders(AbstractHttpMessage request, FetchOptions options, Class<?> requestee) {
        request.setHeader("User-Agent", TCDCommons.getInstance().userAgent);
        request.setHeader("x-tcdcommons-requestee", requestee.getName());
        Header[] headers = options.headers();
        if (headers != null) {
            for (Header header : headers) {
                request.setHeader(header);
            }
        }
    }

    @Nullable
    private static final HttpEntity fetch_bodyToEntity(@Nullable Object body) throws UnsupportedEncodingException {
        if (body == null) {
            return null;
        }
        if (body instanceof HttpEntity) {
            HttpEntity bodyEntity = (HttpEntity)body;
            return bodyEntity;
        }
        if (body instanceof JsonElement) {
            JsonElement jsEl = (JsonElement)body;
            return new StringEntity(jsEl.toString(), ContentType.APPLICATION_JSON);
        }
        if (body instanceof Boolean) {
            Boolean bodyBool = (Boolean)body;
            return new StringEntity(Boolean.toString(bodyBool).toLowerCase(Locale.ENGLISH), (ContentType)null);
        }
        if (body instanceof String || ClassUtils.isPrimitiveOrWrapper(body.getClass())) {
            return new StringEntity(Objects.toString(body), (ContentType)null);
        }
        throw new IllegalArgumentException("Unsupported HTTP body type: " + body.getClass().getName());
    }

    public static interface FetchOptions {
        default public String method() {
            return "GET";
        }

        @Nullable
        default public Header[] headers() {
            return null;
        }

        @Nullable
        default public Object body() {
            return null;
        }
    }
}

