/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.imb11.skinshuffle.SkinShuffle;
import dev.imb11.skinshuffle.api.MojangSkinAPI;
import dev.imb11.skinshuffle.api.SkinShuffleAPI;
import dev.imb11.skinshuffle.api.data.SkinQueryResult;
import dev.imb11.skinshuffle.client.config.SkinShuffleConfig;
import dev.imb11.skinshuffle.client.preset.SkinPreset;
import dev.imb11.skinshuffle.client.skin.ConfigSkin;
import dev.imb11.skinshuffle.client.skin.Skin;
import dev.imb11.skinshuffle.client.skin.UrlSkin;
import dev.imb11.skinshuffle.networking.ClientSkinHandling;
import dev.imb11.skinshuffle.util.NetworkingUtil;
import dev.imb11.skinshuffle.util.SkinCacheRegistry;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_310;

public class SkinPresetManager {
    public static final Path PERSISTENT_SKINS_DIR = SkinShuffle.DATA_DIR.resolve("skins");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final List<SkinPreset> loadedPresets = new ArrayList<SkinPreset>();
    public static boolean LOADING_LOCK = false;
    private static Path PRESETS = SkinShuffle.DATA_DIR.resolve("presets.json");
    private static SkinPreset chosenPreset = null;
    private static SkinPreset apiPreset = null;
    private static SkinShuffleAPI SKIN_SHUFFLE_API;

    public static List<SkinPreset> getLoadedPresets() {
        return Collections.unmodifiableList(loadedPresets);
    }

    public static SkinPreset getChosenPreset() {
        if (chosenPreset == null) {
            if (!loadedPresets.isEmpty()) {
                chosenPreset = loadedPresets.get(0);
            } else {
                chosenPreset = SkinPreset.generateDefaultPreset();
                loadedPresets.add(chosenPreset);
            }
            SkinPresetManager.savePresets();
        }
        return chosenPreset;
    }

    public static SkinPreset getApiPreset() {
        return apiPreset;
    }

    public static void setApiPreset(SkinPreset preset) {
        apiPreset = preset;
    }

    public static Optional<SkinPreset> getPresetByKeybindId(int keybindId) {
        if (keybindId < 0) {
            return Optional.empty();
        }
        return loadedPresets.stream().filter(preset -> preset.getKeybindId() == keybindId).findFirst();
    }

    public static boolean applyPresetByKeybindId(int keybindId) {
        Optional<SkinPreset> preset = SkinPresetManager.getPresetByKeybindId(keybindId);
        if (preset.isPresent()) {
            SkinPresetManager.setChosenPreset(preset.get(), true);
            return true;
        }
        return false;
    }

    public static void swapPresets(int index1, int index2) {
        if (index1 < 0 || index2 < 0 || index1 >= loadedPresets.size() || index2 >= loadedPresets.size()) {
            return;
        }
        Collections.swap(loadedPresets, index1, index2);
        SkinPresetManager.savePresets();
    }

    public static void setChosenPreset(SkinPreset preset, boolean ignoreMatch) {
        if (chosenPreset == preset && !ignoreMatch) {
            return;
        }
        chosenPreset = preset;
        SkinPresetManager.savePresets();
        SkinPresetManager.apply();
    }

    public static void savePresets() {
        JsonObject presetFile = new JsonObject();
        presetFile.addProperty("chosenPreset", (Number)loadedPresets.indexOf(chosenPreset));
        presetFile.addProperty("apiPreset", (Number)(apiPreset == null ? -1 : loadedPresets.indexOf(apiPreset)));
        JsonArray array = new JsonArray();
        for (SkinPreset loadedPreset : loadedPresets) {
            DataResult dataResult = SkinPreset.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)loadedPreset);
            array.add((JsonElement)dataResult.result().orElseThrow(() -> new RuntimeException("Failed to encode skin preset.")));
        }
        presetFile.add("loadedPresets", (JsonElement)array);
        String jsonString = GSON.toJson((JsonElement)presetFile);
        try {
            Files.writeString(PRESETS, (CharSequence)jsonString, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasLoadedPresets() {
        return chosenPreset != null;
    }

    public static Path getAccountPresetsPath(String username) {
        return SkinShuffle.DATA_DIR.resolve("presets-" + username + ".json");
    }

    public static Path getGlobalPresetsPath() {
        return SkinShuffle.DATA_DIR.resolve("presets.json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPresets() {
        if (LOADING_LOCK) {
            return;
        }
        LOADING_LOCK = true;
        SKIN_SHUFFLE_API = new SkinShuffleAPI(SkinShuffleConfig.get().mineskinProxyDomain);
        if (SkinShuffleConfig.get().enableMultiAccountSupport) {
            String username = class_310.method_1551().method_53462().name();
            PRESETS = SkinPresetManager.getAccountPresetsPath(username);
        } else {
            PRESETS = SkinPresetManager.getGlobalPresetsPath();
        }
        if (!Files.exists(PRESETS, new LinkOption[0])) {
            if (chosenPreset == null) {
                apiPreset = chosenPreset = SkinPreset.generateDefaultPreset();
                loadedPresets.add(chosenPreset);
            }
            SkinPresetManager.savePresets();
        }
        loadedPresets.clear();
        chosenPreset = null;
        try {
            String jsonString = Files.readString(PRESETS);
            JsonObject presetFile = (JsonObject)GSON.fromJson(jsonString, JsonObject.class);
            int chosenPresetIndex = presetFile.get("chosenPreset").getAsInt();
            int apiPresetIndex = presetFile.has("apiPreset") ? presetFile.get("apiPreset").getAsInt() : -1;
            JsonArray array = presetFile.get("loadedPresets").getAsJsonArray();
            for (JsonElement jsonElement : array) {
                DataResult dataResult = SkinPreset.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
                Pair pair = (Pair)dataResult.result().orElseThrow(() -> new RuntimeException("Failed to decode skin preset."));
                SkinPreset preset = (SkinPreset)pair.getFirst();
                loadedPresets.add(preset);
            }
            SkinPresetManager.validateAndFixKeybindIds();
            chosenPreset = loadedPresets.get(chosenPresetIndex);
            apiPreset = apiPresetIndex < 0 ? null : loadedPresets.get(apiPresetIndex);
        }
        catch (Exception e) {
            SkinShuffle.LOGGER.error("Failed to load presets, resetting!");
            if (chosenPreset == null) {
                apiPreset = chosenPreset = SkinPreset.generateDefaultPreset();
                loadedPresets.add(chosenPreset);
            }
            SkinPresetManager.savePresets();
        }
        finally {
            LOADING_LOCK = false;
        }
    }

    private static void validateAndFixKeybindIds() {
        if (loadedPresets.isEmpty()) {
            return;
        }
        ArrayList<Integer> usedKeybindIds = new ArrayList<Integer>();
        boolean hasChanges = false;
        for (SkinPreset preset : loadedPresets) {
            int keybindId = preset.getKeybindId();
            if (keybindId == -1) continue;
            if (usedKeybindIds.contains(keybindId)) {
                SkinShuffle.LOGGER.warn("Duplicate keybind ID detected: " + keybindId + ". Resetting to -1 for preset: " + preset.getName());
                preset.setKeybindId(-1);
                hasChanges = true;
                continue;
            }
            usedKeybindIds.add(keybindId);
        }
        if (hasChanges) {
            SkinPresetManager.savePresets();
        }
    }

    public static void setup() {
        try {
            if (!Files.exists(PERSISTENT_SKINS_DIR, new LinkOption[0])) {
                Files.createDirectories(PERSISTENT_SKINS_DIR, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addPreset(SkinPreset preset) {
        loadedPresets.add(preset);
        SkinPresetManager.savePresets();
    }

    public static void deletePreset(SkinPreset skinPreset) {
        loadedPresets.remove(skinPreset);
        if (chosenPreset == skinPreset && !loadedPresets.isEmpty()) {
            chosenPreset = loadedPresets.getFirst();
        }
        SkinPresetManager.savePresets();
    }

    public static void apply() {
        class_310 client = class_310.method_1551();
        SkinPreset preset = SkinPresetManager.getChosenPreset();
        if (SkinShuffleConfig.get().disableAPIUpload) {
            SkinShuffle.LOGGER.info("Skipping skin preset application due to user preference.");
            return;
        }
        if (!NetworkingUtil.isLoggedIn()) {
            SkinShuffle.LOGGER.warn("Skipping skin preset application due to offline mode being active.");
            return;
        }
        try {
            ConfigSkin configSkin = preset.getSkin().saveToConfig();
            try {
                boolean successful;
                Skin skin = preset.getSkin();
                if (skin instanceof UrlSkin) {
                    UrlSkin urlSkin = (UrlSkin)skin;
                    successful = MojangSkinAPI.setSkinTexture(urlSkin.getUrl(), urlSkin.getModel());
                } else {
                    successful = MojangSkinAPI.setSkinTexture(configSkin.getFile().toFile(), configSkin.getModel());
                }
                if (successful) {
                    SkinPresetManager.setApiPreset(preset);
                }
                CompletableFuture.runAsync(() -> client.method_18859(() -> {
                    try {
                        String cachedURL = SkinCacheRegistry.getCachedUploadedSkin(configSkin.getFile().toFile());
                        SkinQueryResult result = cachedURL != null ? SKIN_SHUFFLE_API.uploadUrlSkin(cachedURL, preset.getSkin().getModel()) : SKIN_SHUFFLE_API.uploadFileSkin(configSkin.getFile(), preset.getSkin().getModel());
                        if (result == null) {
                            throw new Exception("Failed to upload skin to MineSkin proxy.");
                        }
                        if (client.field_1687 != null && ClientSkinHandling.isInstalledOnServer()) {
                            ClientSkinHandling.sendRefresh(result);
                        }
                    }
                    catch (Exception e) {
                        SkinShuffle.LOGGER.error(e.getMessage());
                    }
                }), (Executor)class_156.method_18349());
            }
            catch (Exception e) {
                SkinShuffle.LOGGER.error("Failed to apply skin preset.", (Throwable)e);
            }
        }
        catch (Exception ignored) {
            SkinShuffle.LOGGER.info("Skipping skin preset application due to skin not being fully loaded. If this is first startup, please ignore this message.");
        }
        SkinPresetManager.savePresets();
    }
}

