/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.skinshuffle.client.gui.components;

import dev.imb11.skinshuffle.SkinShuffle;
import dev.imb11.skinshuffle.client.gui.components.TabComponent;
import dev.imb11.skinshuffle.client.gui.widgets.buttons.IconButtonWidget;
import dev.imb11.skinshuffle.client.preset.SkinPreset;
import dev.imb11.skinshuffle.client.util.SkinLoader;
import dev.imb11.skinshuffle.client.util.ValidationUtils;
import dev.imb11.skinshuffle.util.ToastHelper;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_342;
import net.minecraft.class_5676;
import net.minecraft.class_7845;
import net.minecraft.class_7940;
import net.minecraft.class_8021;

public class SkinSourceTabComponent
extends TabComponent {
    private final class_310 client;
    private final Consumer<Boolean> onValidationChanged;
    private class_342 textFieldWidget;
    private class_7940 errorLabel;
    private class_5676<String> skinModelButton;
    private IconButtonWidget loadButton;
    private SkinLoader.SourceType currentSourceType;
    private boolean loading = false;

    public SkinSourceTabComponent(class_327 textRenderer, SkinPreset preset, class_310 client, Consumer<Boolean> onValidationChanged) {
        super((class_2561)class_2561.method_43471((String)"skinshuffle.edit.source.title"), textRenderer, preset);
        this.client = client;
        this.onValidationChanged = onValidationChanged;
        this.currentSourceType = SkinLoader.SourceType.UNCHANGED;
    }

    @Override
    public void initialize(int width, int height, int sideMargins) {
        this.field_42139.method_46458().method_46469(width / 3).method_46473(sideMargins).method_46467();
        class_7845.class_7939 gridAdder = this.field_42139.method_48636(4).method_47610(1);
        this.textFieldWidget = new class_342(this.textRenderer, 0, 0, 230, 20, (class_2561)class_2561.method_43473());
        this.textFieldWidget.method_1880(2048);
        this.textFieldWidget.method_1863(str -> this.validateInput());
        this.errorLabel = new class_7940(0, 0, (class_2561)class_2561.method_43473(), this.textRenderer){

            public int method_25364() {
                Objects.requireNonNull(SkinSourceTabComponent.this.textRenderer);
                int minHeight = 9 * 5;
                return Math.max(super.method_25364(), minHeight);
            }
        };
        this.loadButton = new IconButtonWidget(0, 0, 20, 20, 0, 0, 0, 2, 32, 16, 16, 16, 48, SkinShuffle.id("textures/gui/reload-button-icon.png"), button -> {
            if (this.currentSourceType != SkinLoader.SourceType.UNCHANGED) {
                this.loadSkin();
            }
        });
        this.skinModelButton = new class_5676.class_5677(class_2561::method_30163).method_32624((Object[])new String[]{"classic", "slim"}).method_32617(0, 0, 192, 20, (class_2561)class_2561.method_43471((String)"skinshuffle.edit.source.skin_model"), (widget, val) -> this.preset.getSkin().setModel((String)val));
        gridAdder.method_47615((class_8021)new class_5676(0, 0, 192, 20, (class_2561)class_2561.method_43471((String)"skinshuffle.edit.source.cycle_prefix").method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)this.currentSourceType.getTranslationKey())), (class_2561)class_2561.method_43471((String)"skinshuffle.edit.source.cycle_prefix"), Arrays.stream(SkinLoader.SourceType.values()).toList().indexOf((Object)this.currentSourceType), (Object)this.currentSourceType, class_5676.class_5680.method_32627(List.of(SkinLoader.SourceType.values())), sourceType -> class_2561.method_43471((String)sourceType.getTranslationKey()), sourceTypeCyclingButtonWidget -> class_2561.method_30163((String)"").method_27661(), (button, value) -> {
            this.currentSourceType = value;
            this.errorLabel.method_25355((class_2561)class_2561.method_43473());
            this.validateInput();
        }, value -> null, false), this.field_42139.method_46457().method_46471(Math.min(height / 2 - 60, 20)));
        gridAdder.method_47612(this.skinModelButton);
        class_7845 subGrid = new class_7845();
        class_7845.class_7939 subGridAdder = subGrid.method_48635(4).method_47610(2);
        gridAdder.method_47615((class_8021)subGrid, this.field_42139.method_46457().method_46471(6).method_46475(6));
        subGridAdder.method_47612((class_8021)this.textFieldWidget);
        subGridAdder.method_47612((class_8021)this.loadButton);
        gridAdder.method_47615((class_8021)this.errorLabel, this.field_42139.method_46457().method_46461());
        this.validateInput();
    }

    public void validateInput() {
        boolean isValid = true;
        if (this.currentSourceType != SkinLoader.SourceType.UNCHANGED) {
            String input = this.textFieldWidget.method_1882();
            switch (this.currentSourceType) {
                case URL: {
                    boolean bl = ValidationUtils.isValidUrl(input);
                    break;
                }
                case FILE: {
                    boolean bl = ValidationUtils.isValidPngFilePath(input);
                    break;
                }
                case RESOURCE_LOCATION: {
                    boolean bl = ValidationUtils.isValidResourceLocation(input, this.client);
                    break;
                }
                case USERNAME: {
                    boolean bl = ValidationUtils.isValidUsername(input);
                    break;
                }
                case UUID: {
                    boolean bl = ValidationUtils.isValidUUID(input);
                    break;
                }
                default: {
                    boolean bl = isValid = false;
                }
            }
            if (!isValid) {
                this.errorLabel.method_25355((class_2561)class_2561.method_43471((String)this.currentSourceType.getInvalidInputTranslationKey()));
            } else {
                this.errorLabel.method_25355((class_2561)class_2561.method_43473());
            }
        }
        this.textFieldWidget.method_1862(this.currentSourceType != SkinLoader.SourceType.UNCHANGED);
        this.loadButton.field_22764 = this.currentSourceType != SkinLoader.SourceType.UNCHANGED;
        this.loadButton.field_22763 = this.currentSourceType != SkinLoader.SourceType.UNCHANGED && isValid;
        this.skinModelButton.field_22764 = this.currentSourceType != SkinLoader.SourceType.UNCHANGED;
        this.onValidationChanged.accept(isValid);
    }

    public void loadSkin() {
        this.loading = true;
        String skinSource = this.textFieldWidget.method_1882();
        String model = (String)this.skinModelButton.method_32603();
        CompletableFuture<Void> future = SkinLoader.loadSkin(this.currentSourceType, skinSource, model, this.preset);
        future.thenRun(() -> {
            this.loading = false;
        });
    }

    public void handleFileDrop(Path path) {
        if (ValidationUtils.isValidPngFilePath(path.toString())) {
            this.currentSourceType = SkinLoader.SourceType.FILE;
            this.errorLabel.method_25355((class_2561)class_2561.method_43473());
            this.textFieldWidget.method_1852(path.toString());
            this.validateInput();
            this.loadSkin();
        } else {
            ToastHelper.showToast("invalid_dropped_file");
        }
    }

    public SkinLoader.SourceType getCurrentSourceType() {
        return this.currentSourceType;
    }

    public class_342 getTextFieldWidget() {
        return this.textFieldWidget;
    }

    public boolean isLoading() {
        return this.loading;
    }
}

