/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.mc;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.zigythebird.playeranimcore.animation.Animation;
import io.github.kosmx.emotes.mc.McUtils;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3544;
import net.minecraft.class_5455;
import net.minecraft.class_7225;

public class EmoteArgumentProvider
implements SuggestionProvider<class_2168> {
    public final Function<CommandContext<class_2168>, Map<UUID, Animation>> emotes;
    public final class_7225.class_7874 registries;

    public EmoteArgumentProvider(Function<CommandContext<class_2168>, Map<UUID, Animation>> emotes) {
        this((class_7225.class_7874)class_5455.field_40585, emotes);
    }

    public EmoteArgumentProvider(class_7225.class_7874 registries, Function<CommandContext<class_2168>, Map<UUID, Animation>> emotes) {
        this.emotes = emotes;
        this.registries = registries;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        LinkedList<String> suggestions = new LinkedList<String>();
        for (Animation emote : this.emotes.apply(context).values()) {
            if (emote.data().has("name")) {
                Object name = McUtils.fromJson(emote.data().getRaw("name"), this.registries).getString();
                if (((String)name).contains(" ")) {
                    name = "\"" + (String)name + "\"";
                }
                suggestions.add(class_3544.method_57180((String)name));
                continue;
            }
            suggestions.add(emote.uuid().toString());
        }
        return class_2172.method_9253((String[])((String[])suggestions.toArray(String[]::new)), (SuggestionsBuilder)builder);
    }

    public static Animation getEmote(Map<UUID, Animation> emotes, CommandContext<class_2168> context, String argumentName) throws CommandSyntaxException {
        String id = StringArgumentType.getString(context, (String)argumentName);
        try {
            UUID emoteID = UUID.fromString(id);
            Animation emote = emotes.get(emoteID);
            if (emote == null) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("No emote with ID: " + String.valueOf(emoteID)))).create();
            }
            return emote;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            for (Animation emote : emotes.values()) {
                String name;
                if (!emote.data().has("name") || !(name = class_3544.method_57180((String)McUtils.fromJson(emote.data().getRaw("name"), (class_7225.class_7874)class_5455.field_40585).getString())).equals(id)) continue;
                return emote;
            }
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Not emote with name: " + id))).create();
        }
    }
}

