/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.serializer.type;

import com.google.gson.JsonParseException;
import com.zigythebird.playeranimcore.animation.Animation;
import com.zigythebird.playeranimcore.loading.UniversalAnimLoader;
import io.github.kosmx.emotes.server.serializer.type.EmoteSerializerException;
import io.github.kosmx.emotes.server.serializer.type.IReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonEmoteWrapper
implements IReader {
    @Override
    public List<Animation> read(InputStream inputStream, String filename) throws EmoteSerializerException {
        try {
            Map deserialized = UniversalAnimLoader.loadAnimations((InputStream)inputStream);
            if (deserialized == null) {
                throw new IOException("Can't load emote, " + filename + " is empty.");
            }
            return new ArrayList<Animation>(deserialized.values());
        }
        catch (JsonParseException | IOException e) {
            throw new EmoteSerializerException("Exception has occurred", this.getExtension(), e);
        }
    }

    @Override
    public String getExtension() {
        return "json";
    }
}

