/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.managers;

import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import me.cortex.nvidium.sodiumCompat.IRenderSectionExtension;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkUpdateTypes;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.TaskQueueType;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.RenderSectionVisitor;
import net.caffeinemc.mods.sodium.client.render.chunk.occlusion.OcclusionCuller;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortBehavior;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.minecraft.class_1058;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import org.jetbrains.annotations.Nullable;

public class AsyncOcclusionTracker {
    private final OcclusionCuller occlusionCuller;
    private final Thread cullThread;
    private final class_1937 world;
    private volatile boolean running = true;
    private volatile int frame = 0;
    private volatile Viewport viewport = null;
    private final Semaphore framesAhead = new Semaphore(0);
    private final AtomicReference<List<RenderSection>> atomicBfsResult = new AtomicReference();
    private final AtomicReference<List<RenderSection>> blockEntitySectionsRef = new AtomicReference(new ArrayList());
    private final AtomicReference<class_1058[]> visibleAnimatedSpritesRef = new AtomicReference();
    private final Map<TaskQueueType, ArrayDeque<RenderSection>> outputRebuildQueue;
    private final float renderDistance;
    private volatile long iterationTimeMillis;
    private volatile boolean shouldUseOcclusionCulling = true;
    private volatile int chunkVisibilityCount = 0;

    public AsyncOcclusionTracker(int renderDistance, Long2ReferenceMap<RenderSection> sections, class_1937 world, Map<TaskQueueType, ArrayDeque<RenderSection>> outputRebuildQueue) {
        this.occlusionCuller = new OcclusionCuller(sections, world);
        this.cullThread = new Thread(this::run);
        this.cullThread.setName("Cull thread");
        this.cullThread.setPriority(10);
        this.cullThread.start();
        this.renderDistance = (float)renderDistance * 16.0f;
        this.outputRebuildQueue = outputRebuildQueue;
        this.world = world;
    }

    private void run() {
        while (this.running) {
            List previous;
            this.framesAhead.acquireUninterruptibly();
            if (!this.running) break;
            long startTime = System.currentTimeMillis();
            boolean animateVisibleSpritesOnly = SodiumClientMod.options().performance.animateOnlyVisibleTextures;
            ArrayList chunkUpdates = new ArrayList();
            ArrayList blockEntitySections = new ArrayList();
            HashSet animatedSpriteSet = animateVisibleSpritesOnly ? new HashSet() : null;
            int[] visibleGeometryCounter = new int[1];
            RenderSectionVisitor visitor = section -> {
                class_1058[] animatedSprites;
                if (section.getPendingUpdate() != 0 && section.getRunningJob() == null && !((IRenderSectionExtension)section).isSubmittedRebuild() && !((IRenderSectionExtension)section).isSeen()) {
                    ((IRenderSectionExtension)section).isSeen(true);
                    chunkUpdates.add(section);
                }
                if ((section.getFlags() & 1) != 0) {
                    visibleGeometryCounter[0] = visibleGeometryCounter[0] + 1;
                }
                if ((section.getFlags() & 2) != 0 && section.getPosition().method_19771((class_2382)this.viewport.getChunkCoord(), 33.0)) {
                    blockEntitySections.add(section);
                }
                if (animateVisibleSpritesOnly && (section.getFlags() & 4) != 0 && section.getPosition().method_19771((class_2382)this.viewport.getChunkCoord(), 33.0) && (animatedSprites = section.getAnimatedSprites()) != null) {
                    animatedSpriteSet.addAll(List.of(animatedSprites));
                }
            };
            ++this.frame;
            float searchDistance = this.getSearchDistance();
            boolean useOcclusionCulling = this.shouldUseOcclusionCulling;
            try {
                this.occlusionCuller.findVisible(visitor, this.viewport, searchDistance, useOcclusionCulling, this.frame);
            }
            catch (Throwable e) {
                System.err.println("Error doing traversal");
                e.printStackTrace();
            }
            if (!chunkUpdates.isEmpty() && (previous = (List)this.atomicBfsResult.getAndSet(chunkUpdates)) != null) {
                for (RenderSection section2 : previous) {
                    if (section2.isDisposed()) continue;
                    ((IRenderSectionExtension)section2).isSeen(false);
                }
            }
            this.chunkVisibilityCount = visibleGeometryCounter[0];
            this.blockEntitySectionsRef.set(blockEntitySections);
            this.visibleAnimatedSpritesRef.set(animatedSpriteSet == null ? null : animatedSpriteSet.toArray(new class_1058[0]));
            this.iterationTimeMillis = System.currentTimeMillis() - startTime;
        }
    }

    public final void update(Viewport viewport, class_4184 camera, boolean spectator) {
        List bfsResult;
        this.shouldUseOcclusionCulling = this.shouldUseOcclusionCulling(camera, spectator);
        this.viewport = viewport;
        if (this.framesAhead.availablePermits() < 5) {
            this.framesAhead.release();
        }
        if ((bfsResult = (List)this.atomicBfsResult.getAndSet(null)) != null) {
            for (RenderSection section : bfsResult) {
                TaskQueueType queueType;
                ArrayDeque<RenderSection> queue;
                if (section.isDisposed()) continue;
                int updateType = section.getPendingUpdate();
                if (updateType != 0 && section.getRunningJob() == null && (queue = this.outputRebuildQueue.get(queueType = ChunkUpdateTypes.getQueueType((int)updateType, (TaskQueueType)SodiumClientMod.options().performance.chunkBuildDeferMode.getImportantRebuildQueueType(), (TaskQueueType)SortBehavior.DYNAMIC_DEFER_NEARBY_ZERO_FRAMES.getDeferMode().getImportantRebuildQueueType()))).size() < queueType.queueSizeLimit()) {
                    ((IRenderSectionExtension)section).isSubmittedRebuild(true);
                    queue.add(section);
                }
                ((IRenderSectionExtension)section).isSeen(false);
            }
        }
    }

    public void delete() {
        this.running = false;
        this.framesAhead.release(1000);
        try {
            this.cullThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private float getSearchDistance() {
        return this.renderDistance;
    }

    private boolean shouldUseOcclusionCulling(class_4184 camera, boolean spectator) {
        class_2338 origin = camera.method_19328();
        boolean useOcclusionCulling = spectator && this.world.method_8320(origin).method_26216() ? false : class_310.method_1551().field_1730;
        return useOcclusionCulling;
    }

    public int getFrame() {
        return this.frame;
    }

    public List<RenderSection> getLatestSectionsWithEntities() {
        return this.blockEntitySectionsRef.get();
    }

    @Nullable
    public class_1058[] getVisibleAnimatedSprites() {
        return this.visibleAnimatedSpritesRef.get();
    }

    public long getIterationTime() {
        return this.iterationTimeMillis;
    }

    public int[] getBuildQueueSizes() {
        int[] ret = new int[this.outputRebuildQueue.size()];
        for (TaskQueueType type : TaskQueueType.values()) {
            ret[type.ordinal()] = this.outputRebuildQueue.get(type).size();
        }
        return ret;
    }

    public int getLastVisibilityCount() {
        return this.chunkVisibilityCount;
    }
}

