/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.managers;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import me.cortex.nvidium.Nvidium;
import me.cortex.nvidium.NvidiumWorldRenderer;
import me.cortex.nvidium.config.TranslucencySortingLevel;
import me.cortex.nvidium.gl.RenderDevice;
import me.cortex.nvidium.managers.RegionManager;
import me.cortex.nvidium.sodiumCompat.INvidiumWorldRendererGetter;
import me.cortex.nvidium.sodiumCompat.IRepackagedResult;
import me.cortex.nvidium.sodiumCompat.RepackagedSectionOutput;
import me.cortex.nvidium.util.BufferArena;
import me.cortex.nvidium.util.UploadingBufferStream;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkSortOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;
import net.minecraft.class_4076;
import org.joml.Vector3i;
import org.joml.Vector4i;
import org.lwjgl.system.MemoryUtil;

public class SectionManager {
    public static final int SECTION_SIZE = 48;
    private final RegionManager regionManager;
    private final Long2IntOpenHashMap section2id = new Long2IntOpenHashMap();
    private final Long2IntOpenHashMap section2terrain = new Long2IntOpenHashMap();
    private final Long2IntOpenHashMap section2index = new Long2IntOpenHashMap();
    public final UploadingBufferStream uploadStream;
    public final BufferArena terrainAreana;
    public final BufferArena translucencyIndexArena;
    private final Long2ObjectOpenHashMap<int[]> translucencyQuadCounts = new Long2ObjectOpenHashMap();
    private final RenderDevice device;
    private final LongSet hiddenSectionKeys = new LongOpenHashSet();

    public SectionManager(RenderDevice device, long fallbackMemorySize, UploadingBufferStream uploadStream, int quadVertexSize, NvidiumWorldRenderer worldRenderer) {
        int maxRegions = 50000;
        this.device = device;
        this.uploadStream = uploadStream;
        this.terrainAreana = new BufferArena(device, fallbackMemorySize, quadVertexSize);
        this.translucencyIndexArena = new BufferArena(device, fallbackMemorySize, 1);
        this.regionManager = new RegionManager(device, maxRegions, maxRegions * 200, uploadStream, worldRenderer::enqueueRegionSort);
        this.section2id.defaultReturnValue(-1);
        this.section2terrain.defaultReturnValue(-1);
        this.section2index.defaultReturnValue(-1);
        this.translucencyQuadCounts.defaultReturnValue(null);
    }

    public void uploadIndexBuffer(IntBuffer indexBuffer, int[] quadCountData, long upload) {
        int quadOffset = 0;
        for (ModelQuadFacing facing : ModelQuadFacing.values()) {
            for (int i = 0; i < quadCountData[facing.ordinal()]; ++i) {
                int idx = indexBuffer.get((quadOffset + i) * 6) / 4 + quadOffset;
                MemoryUtil.memPutInt((long)(upload + (long)(quadOffset + i) * 4L), (int)idx);
            }
            quadOffset += quadCountData[facing.ordinal()];
        }
    }

    public void uploadChunkSort(ChunkSortOutput sortOutput) {
        if (sortOutput.getSorter() == null) {
            return;
        }
        NativeBuffer indexBuffer = sortOutput.getSorter().getIndexBuffer();
        if (indexBuffer == null) {
            return;
        }
        RenderSection section = sortOutput.render;
        long sectionKey = class_4076.method_18685((int)section.getChunkX(), (int)section.getChunkY(), (int)section.getChunkZ());
        int[] quadCountData = (int[])this.translucencyQuadCounts.get(sectionKey);
        if (quadCountData == null) {
            return;
        }
        if (quadCountData[7] * 6 * 4 != indexBuffer.getLength()) {
            Nvidium.LOGGER.error("ChunkSortOutput integrity check failed at {} {} {}, aborting (totalQuads={};indexBuffer={})", new Object[]{section.getChunkX(), section.getChunkY(), section.getChunkZ(), quadCountData[7], indexBuffer.getLength() / 24});
            return;
        }
        int idxBufferLength = indexBuffer.getLength() / 6;
        IntBuffer idxBuffer = indexBuffer.getDirectBuffer().asIntBuffer();
        int indexDataAddress = this.section2index.get(sectionKey);
        if (indexDataAddress != -1 && !this.translucencyIndexArena.canReuse(indexDataAddress, idxBufferLength)) {
            this.section2index.remove(sectionKey);
            this.translucencyIndexArena.free(indexDataAddress);
            indexDataAddress = -1;
        }
        if (indexDataAddress == -1) {
            indexDataAddress = this.translucencyIndexArena.allocQuads(idxBufferLength);
        }
        this.section2index.put(sectionKey, indexDataAddress);
        long upload = this.translucencyIndexArena.upload(this.uploadStream, indexDataAddress);
        this.uploadIndexBuffer(idxBuffer, quadCountData, upload);
        int sectionIdx = this.section2id.get(sectionKey);
        if (sectionIdx == -1) {
            Nvidium.LOGGER.error("Got translucency data but no section found for {}", (Object)sectionKey);
            return;
        }
        long metadata = this.regionManager.setSectionData(sectionIdx);
        MemoryUtil.memPutInt((long)(metadata += 32L), (int)indexDataAddress);
    }

    public void uploadChunkBuildResult(ChunkBuildOutput result) {
        int terrainAddress;
        RepackagedSectionOutput output = ((IRepackagedResult)result).getOutput();
        RenderSection section = result.render;
        long sectionKey = class_4076.method_18685((int)section.getChunkX(), (int)section.getChunkY(), (int)section.getChunkZ());
        if (output == null || output.quads() == 0) {
            this.deleteSection(sectionKey);
            return;
        }
        BuiltSectionMeshParts translucentData = (BuiltSectionMeshParts)result.meshes.get(DefaultTerrainRenderPasses.TRANSLUCENT);
        if (translucentData != null) {
            int[] quadOffsets = new int[8];
            for (int i = 0; i < ModelQuadFacing.COUNT; ++i) {
                int count = translucentData.getVertexSegments()[i * 2];
                int facing = translucentData.getVertexSegments()[i * 2 + 1];
                if (count <= 0) continue;
                quadOffsets[facing] = count / 4;
                quadOffsets[7] = quadOffsets[7] + count / 4;
            }
            this.translucencyQuadCounts.put(sectionKey, (Object)quadOffsets);
        }
        if ((terrainAddress = this.section2terrain.get(sectionKey)) != -1 && !this.terrainAreana.canReuse(terrainAddress, output.quads())) {
            this.section2terrain.remove(sectionKey);
            this.terrainAreana.free(terrainAddress);
            terrainAddress = -1;
        }
        if (terrainAddress == -1) {
            terrainAddress = this.terrainAreana.allocQuads(output.quads());
        }
        if ((long)terrainAddress == -1L) {
            Nvidium.LOGGER.error("Terrain arena critically out of memory, expect issues with chunks!!  quad_used: " + this.terrainAreana.getUsedMB() + " physically used: " + this.terrainAreana.getMemoryUsed() + " limit: " + ((INvidiumWorldRendererGetter)SodiumWorldRenderer.instance()).getRenderer().getMaxGeometryMemory());
            this.deleteSection(sectionKey);
            return;
        }
        this.section2terrain.put(sectionKey, terrainAddress);
        long geometryUpload = this.terrainAreana.upload(this.uploadStream, terrainAddress);
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)output.geometry().getDirectBuffer()), (long)geometryUpload, (long)output.geometry().getLength());
        int sectionIdx = this.section2id.computeIfAbsent(sectionKey, key -> this.regionManager.allocateSection(class_4076.method_18686((long)key), class_4076.method_18689((long)key), class_4076.method_18690((long)key)));
        long metadata = this.regionManager.setSectionData(sectionIdx);
        boolean hideSectionBitSet = this.hiddenSectionKeys.contains(sectionKey);
        Vector3i min = output.min();
        Vector3i size = output.size();
        int px = section.getChunkX() << 8 | size.x << 4 | min.x;
        int py = (section.getChunkY() & 0x1FF) << 8 | size.y << 4 | min.y | (hideSectionBitSet ? 131072 : 0) | this.regionManager.getSectionRefId(sectionIdx) << 18;
        int pz = section.getChunkZ() << 8 | size.z << 4 | min.z;
        int pw = terrainAddress;
        new Vector4i(px, py, pz, pw).getToAddress(metadata);
        metadata += 16L;
        for (int i = 0; i < 4; ++i) {
            int geo = Short.toUnsignedInt(output.offsets()[i * 2]) | Short.toUnsignedInt(output.offsets()[i * 2 + 1]) << 16;
            MemoryUtil.memPutInt((long)metadata, (int)geo);
            metadata += 4L;
        }
        if (Nvidium.config.translucency_sorting_level == TranslucencySortingLevel.SODIUM) {
            if (result.isReusingUploadedIndexData()) {
                MemoryUtil.memPutInt((long)metadata, (int)this.section2index.get(sectionKey));
            } else {
                MemoryUtil.memPutInt((long)metadata, (int)-1);
                int idxIndex = this.section2index.remove(sectionKey);
                if (idxIndex != -1) {
                    this.translucencyIndexArena.free(idxIndex);
                }
            }
        }
    }

    public void setHideBit(int x, int y, int z, boolean hide) {
        long sectionKey = class_4076.method_18685((int)x, (int)y, (int)z);
        if (hide ? !this.hiddenSectionKeys.add(sectionKey) : !this.hiddenSectionKeys.remove(sectionKey)) {
            return;
        }
        int sectionId = this.section2id.get(sectionKey);
        if (sectionId != -1) {
            long metadata = this.regionManager.setSectionData(sectionId);
            MemoryUtil.memPutInt((long)(metadata + 4L), (int)(MemoryUtil.memGetInt((long)(metadata + 4L)) & 0xFFFDFFFF | (hide ? 1 : 0) << 17));
        }
    }

    public void deleteSection(RenderSection section) {
        this.deleteSection(class_4076.method_18685((int)section.getChunkX(), (int)section.getChunkY(), (int)section.getChunkZ()));
    }

    private void deleteSection(long sectionKey) {
        int sectionIdx = this.section2id.remove(sectionKey);
        if (sectionIdx != -1) {
            int indexIdx;
            int terrainIndex = this.section2terrain.remove(sectionKey);
            if (terrainIndex != -1) {
                this.terrainAreana.free(terrainIndex);
            }
            if ((indexIdx = this.section2index.remove(sectionKey)) != -1) {
                this.translucencyIndexArena.free(indexIdx);
            }
            this.translucencyQuadCounts.remove(sectionKey);
            this.regionManager.removeSection(sectionIdx);
        }
    }

    public void destroy() {
        this.regionManager.destroy();
        this.terrainAreana.delete();
        this.translucencyIndexArena.delete();
    }

    public void commitChanges() {
        this.regionManager.commitChanges();
    }

    public RegionManager getRegionManager() {
        return this.regionManager;
    }

    public void removeRegionById(int regionId) {
        if (!this.regionManager.regionExists(regionId)) {
            return;
        }
        long rk = this.regionManager.regionIdToKey(regionId);
        int X = class_4076.method_18686((long)rk) << 3;
        int Y = class_4076.method_18689((long)rk) << 2;
        int Z = class_4076.method_18690((long)rk) << 3;
        for (int x = X; x < X + 8; ++x) {
            for (int y = Y; y < Y + 4; ++y) {
                for (int z = Z; z < Z + 8; ++z) {
                    this.deleteSection(class_4076.method_18685((int)x, (int)y, (int)z));
                }
            }
        }
    }
}

