/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.mixin.sodium;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import me.cortex.nvidium.Nvidium;
import me.cortex.nvidium.NvidiumWorldRenderer;
import me.cortex.nvidium.managers.AsyncOcclusionTracker;
import me.cortex.nvidium.sodiumCompat.INvidiumWorldRendererGetter;
import me.cortex.nvidium.sodiumCompat.INvidiumWorldRendererSetter;
import me.cortex.nvidium.sodiumCompat.IRenderSectionExtension;
import me.cortex.nvidium.sodiumCompat.IrisCheck;
import me.cortex.nvidium.sodiumCompat.NvidiumCompactChunkVertex;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.client.SodiumClientMod;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkUpdateTypes;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.TaskQueueType;
import net.caffeinemc.mods.sodium.client.render.chunk.lists.SectionCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortBehavior;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.caffeinemc.mods.sodium.client.render.viewport.Viewport;
import net.caffeinemc.mods.sodium.client.util.FogParameters;
import net.caffeinemc.mods.sodium.mixin.core.GlCommandEncoderAccessor;
import net.minecraft.class_1058;
import net.minecraft.class_10865;
import net.minecraft.class_10868;
import net.minecraft.class_1937;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RenderSectionManager.class}, remap=false, priority=1500)
public class MixinRenderSectionManager
implements INvidiumWorldRendererGetter {
    @Shadow
    @Final
    private RenderRegionManager regions;
    @Shadow
    @Final
    private Long2ReferenceMap<RenderSection> sectionByPosition;
    @Shadow
    @NotNull
    private Map<TaskQueueType, ArrayDeque<RenderSection>> taskLists;
    @Unique
    private NvidiumWorldRenderer renderer;
    @Unique
    private Viewport viewport;

    @Unique
    private static void updateNvidiumIsEnabled() {
        Nvidium.IS_ENABLED = !Nvidium.FORCE_DISABLE && Nvidium.IS_COMPATIBLE && IrisCheck.checkIrisShouldDisable();
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(class_638 level, int renderDistance, SortBehavior sortBehavior, CommandList commandList, CallbackInfo ci) {
        MixinRenderSectionManager.updateNvidiumIsEnabled();
        if (Nvidium.IS_ENABLED) {
            if (this.renderer != null) {
                throw new IllegalStateException("Cannot have multiple world renderers");
            }
            this.renderer = new NvidiumWorldRenderer(Nvidium.config.async_bfs ? new AsyncOcclusionTracker(renderDistance, this.sectionByPosition, (class_1937)level, this.taskLists) : null);
            ((INvidiumWorldRendererSetter)this.regions).setWorldRenderer(this.renderer);
        }
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/compile/executor/ChunkBuilder;<init>(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/caffeinemc/mods/sodium/client/render/chunk/vertex/format/ChunkVertexType;)V", remap=true), index=1)
    private ChunkVertexType modifyVertexType(ChunkVertexType vertexType) {
        MixinRenderSectionManager.updateNvidiumIsEnabled();
        if (Nvidium.IS_ENABLED && !Nvidium.config.use_sodium_vertex_format) {
            return NvidiumCompactChunkVertex.INSTANCE;
        }
        return vertexType;
    }

    @Inject(method={"destroy"}, at={@At(value="TAIL")})
    private void destroy(CallbackInfo ci) {
        if (Nvidium.IS_ENABLED) {
            if (this.renderer == null) {
                throw new IllegalStateException("Pipeline already destroyed");
            }
            ((INvidiumWorldRendererSetter)this.regions).setWorldRenderer(null);
            this.renderer.delete();
            this.renderer = null;
        }
    }

    @Redirect(method={"onSectionRemoved"}, at=@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/RenderSection;delete()V"))
    private void deleteSection(RenderSection section) {
        if (Nvidium.IS_ENABLED && (Nvidium.config.region_keep_distance == 32 || Nvidium.config.region_keep_distance <= class_310.method_1551().field_1690.method_38521())) {
            this.renderer.deleteSection(section);
        }
        section.delete();
    }

    @Inject(method={"update"}, at={@At(value="HEAD")})
    private void trackViewport(class_4184 camera, Viewport viewport, FogParameters fogParameters, boolean spectator, CallbackInfo ci) {
        this.viewport = viewport;
    }

    @Inject(method={"renderLayer"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderLayer(ChunkRenderMatrices matrices, TerrainRenderPass pass, double x, double y, double z, FogParameters fogParameters, CallbackInfo ci) {
        if (Nvidium.IS_ENABLED) {
            ci.cancel();
            if (pass == DefaultTerrainRenderPasses.CUTOUT) {
                return;
            }
            class_276 target = pass.getTarget();
            GlStateManager._viewport((int)0, (int)0, (int)target.method_30277().getWidth(0), (int)target.method_30277().getHeight(0));
            GlStateManager._glBindFramebuffer((int)36160, (int)((class_10868)target.method_30277()).method_68426(((class_10865)RenderSystem.getDevice()).method_68401(), target.method_30278()));
            ((GlCommandEncoderAccessor)RenderSystem.getDevice().createCommandEncoder()).sodium$applyPipelineState(pass.getPipeline());
            ((GlCommandEncoderAccessor)RenderSystem.getDevice().createCommandEncoder()).sodium$setLastProgram(null);
            if (pass == DefaultTerrainRenderPasses.SOLID) {
                this.renderer.renderFrame(pass, this.viewport, fogParameters, matrices, x, y, z);
            } else if (pass == DefaultTerrainRenderPasses.TRANSLUCENT) {
                this.renderer.renderTranslucent(pass);
            }
        }
    }

    @Inject(method={"getDebugStrings"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectDebug(CallbackInfoReturnable<Collection<String>> cir) {
        if (Nvidium.IS_ENABLED) {
            ArrayList<String> debugStrings = new ArrayList<String>();
            this.renderer.addDebugInfo(debugStrings);
            cir.setReturnValue(debugStrings);
            cir.cancel();
        }
    }

    @Override
    public NvidiumWorldRenderer getRenderer() {
        return this.renderer;
    }

    @Inject(method={"createTerrainRenderList"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectTerrainRenderList(class_4184 camera, Viewport viewport, FogParameters fogParameters, int frame, boolean spectator, CallbackInfoReturnable<Boolean> cir) {
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs) {
            cir.setReturnValue((Object)false);
            cir.cancel();
        }
    }

    @Redirect(method={"processChunkBuildResults(Ljava/util/ArrayList;)Z"}, at=@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/lists/SectionCollector;visit(Lnet/caffeinemc/mods/sodium/client/render/chunk/RenderSection;)V"))
    public void processChunkBuildResultsVisit(SectionCollector instance, RenderSection renderList) {
        if (Nvidium.IS_ENABLED && !Nvidium.config.async_bfs) {
            instance.visit(renderList);
        }
    }

    @Redirect(method={"submitSectionTask(Lnet/caffeinemc/mods/sodium/client/render/chunk/compile/executor/ChunkJobCollector;Lnet/caffeinemc/mods/sodium/client/render/chunk/RenderSection;ILnet/caffeinemc/mods/sodium/client/render/chunk/compile/estimation/UploadResourceBudget;Z)V"}, at=@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/RenderSection;clearPendingUpdate()V"))
    private void injectEnqueueFalse(RenderSection instance) {
        instance.clearPendingUpdate();
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs) {
            ((IRenderSectionExtension)instance).isSubmittedRebuild(false);
        }
    }

    @Unique
    private boolean isSectionVisibleBfs(RenderSection section) {
        int delta = Math.abs(section.getLastVisibleFrame() - this.renderer.getAsyncFrameId());
        return delta <= 1;
    }

    @Inject(method={"isSectionVisible"}, at={@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/RenderSection;getLastVisibleFrame()I", shift=At.Shift.BEFORE)}, cancellable=true)
    private void redirectIsSectionVisible(int x, int y, int z, CallbackInfoReturnable<Boolean> cir, @Local RenderSection render) {
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs) {
            cir.setReturnValue((Object)this.isSectionVisibleBfs(render));
        }
    }

    @Inject(method={"tickVisibleRenders"}, at={@At(value="HEAD")}, cancellable=true)
    private void redirectAnimatedSpriteUpdates(CallbackInfo ci) {
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs && SodiumClientMod.options().performance.animateOnlyVisibleTextures) {
            ci.cancel();
            class_1058[] sprites = this.renderer.getAnimatedSpriteSet();
            if (sprites == null) {
                return;
            }
            for (class_1058 sprite : sprites) {
                SpriteUtil.INSTANCE.markSpriteActive(sprite);
            }
        }
    }

    @Inject(method={"scheduleRebuild"}, at={@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/RenderSectionManager;upgradePendingUpdate(Lnet/caffeinemc/mods/sodium/client/render/chunk/RenderSection;I)Z", shift=At.Shift.AFTER)})
    private void instantReschedule(int x, int y, int z, boolean playerChanged, CallbackInfo ci, @Local RenderSection section, @Local(ordinal=3) int pendingUpdate) {
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs) {
            TaskQueueType queueType = ChunkUpdateTypes.getQueueType((int)pendingUpdate, (TaskQueueType)SodiumClientMod.options().performance.chunkBuildDeferMode.getImportantRebuildQueueType(), (TaskQueueType)SortBehavior.DYNAMIC_DEFER_NEARBY_ZERO_FRAMES.getDeferMode().getImportantRebuildQueueType());
            ArrayDeque<RenderSection> queue = this.taskLists.get(queueType);
            if (this.isSectionVisibleBfs(section) && !queue.contains(section)) {
                ((IRenderSectionExtension)section).isSubmittedRebuild(true);
                this.taskLists.get(queueType).add(section);
            }
        }
    }

    @Inject(method={"scheduleSort(JZ)V"}, at={@At(value="INVOKE", target="Lnet/caffeinemc/mods/sodium/client/render/chunk/RenderSectionManager;upgradePendingUpdate(Lnet/caffeinemc/mods/sodium/client/render/chunk/RenderSection;I)Z")})
    public void promoteScheduleSort(long sectionPos, boolean isDirectTrigger, CallbackInfo ci, @Local RenderSection section, @Local int pendingUpdate) {
        if (Nvidium.IS_ENABLED && section.getPendingUpdate() != 0 && pendingUpdate != section.getPendingUpdate()) {
            TaskQueueType oldQueue = ChunkUpdateTypes.getQueueType((int)section.getPendingUpdate(), (TaskQueueType)SodiumClientMod.options().performance.chunkBuildDeferMode.getImportantRebuildQueueType(), (TaskQueueType)SortBehavior.DYNAMIC_DEFER_NEARBY_ZERO_FRAMES.getDeferMode().getImportantRebuildQueueType());
            this.taskLists.get(oldQueue).remove(section);
            TaskQueueType newQueue = ChunkUpdateTypes.getQueueType((int)pendingUpdate, (TaskQueueType)SodiumClientMod.options().performance.chunkBuildDeferMode.getImportantRebuildQueueType(), (TaskQueueType)SortBehavior.DYNAMIC_DEFER_NEARBY_ZERO_FRAMES.getDeferMode().getImportantRebuildQueueType());
            this.taskLists.get(newQueue).add(section);
        }
    }

    @Inject(method={"getVisibleChunkCount"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectVisibilityCount(CallbackInfoReturnable<Integer> cir) {
        if (Nvidium.IS_ENABLED && Nvidium.config.async_bfs) {
            cir.setReturnValue((Object)this.renderer.getAsyncBfsVisibilityCount());
        }
    }
}

