/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.sodiumCompat;

import java.util.function.Consumer;
import me.cortex.nvidium.Nvidium;
import me.cortex.nvidium.config.StatisticsLoggingLevel;
import me.cortex.nvidium.config.TranslucencySortingLevel;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderConstants;
import net.caffeinemc.mods.sodium.client.gl.shader.ShaderParser;
import net.minecraft.class_2960;

public class ShaderLoader {
    public static String parse(class_2960 path) {
        return ShaderLoader.parse(path, shaderConstants -> {});
    }

    public static String parse(class_2960 path, Consumer<ShaderConstants.Builder> constantBuilder) {
        ShaderConstants.Builder builder = ShaderConstants.builder();
        if (Nvidium.IS_DEBUG) {
            builder.add("DEBUG");
        }
        for (int i = 1; i <= Nvidium.config.statistics_level.ordinal(); ++i) {
            builder.add("STATISTICS_" + StatisticsLoggingLevel.values()[i].name());
        }
        if (Nvidium.config.translucency_sorting_level.ordinal() >= TranslucencySortingLevel.SECTIONS.ordinal()) {
            builder.add("TRANSLUCENCY_SORTING_SECTIONS");
        }
        if (Nvidium.config.translucency_sorting_level == TranslucencySortingLevel.QUADS) {
            builder.add("TRANSLUCENCY_SORTING_QUADS");
        }
        if (Nvidium.config.translucency_sorting_level == TranslucencySortingLevel.SODIUM) {
            builder.add("TRANSLUCENCY_SORTING_SODIUM");
        }
        if (Nvidium.config.render_fog) {
            builder.add("RENDER_FOG");
        }
        if (Nvidium.config.use_sodium_vertex_format) {
            builder.add("USE_SODIUM_VERTEX_FORMAT");
        }
        if (Nvidium.config.cull_degenerate_triangles) {
            builder.add("CULL_DEGENERATE_TRIANGLES");
        }
        if (Nvidium.config.use_nv_fragment_shader_barycentric) {
            builder.add("USE_NV_FRAGMENT_SHADER_BARYCENTRIC");
        }
        builder.add("TEXTURE_MAX_SCALE", String.valueOf(32768));
        constantBuilder.accept(builder);
        String shaderSrc = net.caffeinemc.mods.sodium.client.gl.shader.ShaderLoader.getShaderSource((class_2960)path);
        return ShaderParser.parseShader((String)shaderSrc, (ShaderConstants)builder.build()).src();
    }
}

