/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.sodiumCompat;

import it.unimi.dsi.fastutil.longs.LongArrays;
import java.nio.ByteBuffer;
import me.cortex.nvidium.Nvidium;
import me.cortex.nvidium.config.TranslucencySortingLevel;
import me.cortex.nvidium.sodiumCompat.RepackagedSectionOutput;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.ChunkBuildOutput;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.DefaultTerrainRenderPasses;
import net.caffeinemc.mods.sodium.client.render.chunk.vertex.format.ChunkMeshFormats;
import net.caffeinemc.mods.sodium.client.util.NativeBuffer;
import net.minecraft.class_243;
import net.minecraft.class_310;
import org.joml.Vector3i;
import org.lwjgl.system.MemoryUtil;

public class SodiumResultCompatibility {
    public static RepackagedSectionOutput repackage(ChunkBuildOutput result) {
        int formatSize = Nvidium.config.use_sodium_vertex_format ? ChunkMeshFormats.COMPACT.getVertexFormat().getStride() : 16;
        int geometryBytes = result.meshes.values().stream().mapToInt(a -> a.getVertexData().getLength()).sum();
        NativeBuffer output = new NativeBuffer(geometryBytes);
        short[] offsets = new short[8];
        Vector3i min = new Vector3i(2000);
        Vector3i max = new Vector3i(-2000);
        SodiumResultCompatibility.packageSectionGeometry(formatSize, output, offsets, result, min, max);
        min.x = Math.max(min.x, 0);
        min.y = Math.max(min.y, 0);
        min.z = Math.max(min.z, 0);
        min.x = Math.min(min.x, 15);
        min.y = Math.min(min.y, 15);
        min.z = Math.min(min.z, 15);
        max.x = Math.min(max.x, 16);
        max.y = Math.min(max.y, 16);
        max.z = Math.min(max.z, 16);
        max.x = Math.max(max.x, 0);
        max.y = Math.max(max.y, 0);
        max.z = Math.max(max.z, 0);
        Vector3i size = new Vector3i(max.x - min.x - 1, max.y - min.y - 1, max.z - min.z - 1);
        size.x = Math.min(15, Math.max(size.x, 0));
        size.y = Math.min(15, Math.max(size.y, 0));
        size.z = Math.min(15, Math.max(size.z, 0));
        RepackagedSectionOutput repackagedGeometry = new RepackagedSectionOutput(geometryBytes / formatSize / 4, output, offsets, min, size);
        return repackagedGeometry;
    }

    private static void copyQuad(long from, long too) {
        long quadSize = Nvidium.config.use_sodium_vertex_format ? 80L : 64L;
        MemoryUtil.memCopy((long)from, (long)too, (long)quadSize);
    }

    private static int[] computeRanges(int[] segments) {
        int[] ranges = new int[14];
        int offset = 0;
        for (int i = 0; i < ModelQuadFacing.COUNT; ++i) {
            int count = segments[i * 2];
            int facing = segments[i * 2 + 1];
            if (count > 0) {
                ranges[facing * 2 + 1] = count;
                ranges[facing * 2] = offset;
            }
            offset += count;
        }
        return ranges;
    }

    private static int copyRange(BuiltSectionMeshParts meshData, int offset, int count, long dst, int formatSize, Vector3i min, Vector3i max) {
        long src = MemoryUtil.memAddress((ByteBuffer)meshData.getVertexData().getDirectBuffer()) + (long)offset * (long)formatSize;
        MemoryUtil.memCopy((long)src, (long)dst, (long)((long)count * (long)formatSize));
        for (int j = 0; j < count; ++j) {
            long base = dst + (long)j * (long)formatSize;
            SodiumResultCompatibility.updateSectionBounds(min, max, base);
        }
        return count / 4;
    }

    private static void packageSectionGeometry(int formatSize, NativeBuffer output, short[] outOffsets, ChunkBuildOutput result, Vector3i min, Vector3i max) {
        int offset = 0;
        long outPtr = MemoryUtil.memAddress((ByteBuffer)output.getDirectBuffer());
        BuiltSectionMeshParts translucentData = (BuiltSectionMeshParts)result.meshes.get(DefaultTerrainRenderPasses.TRANSLUCENT);
        if (translucentData != null && Nvidium.config.translucency_sorting_level == TranslucencySortingLevel.SODIUM) {
            int[] translucentRanges = SodiumResultCompatibility.computeRanges(translucentData.getVertexSegments());
            for (int i = 0; i < ModelQuadFacing.COUNT; ++i) {
                offset += SodiumResultCompatibility.copyRange(translucentData, translucentRanges[i * 2], translucentRanges[i * 2 + 1], outPtr + (long)offset * 4L * (long)formatSize, formatSize, min, max);
            }
        } else if (translucentData != null) {
            int i;
            class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
            float cpx = (float)(cameraPos.field_1352 - (double)(result.render.getChunkX() << 4));
            float cpy = (float)(cameraPos.field_1351 - (double)(result.render.getChunkY() << 4));
            float cpz = (float)(cameraPos.field_1350 - (double)(result.render.getChunkZ() << 4));
            float len = (float)Math.sqrt(cpx * cpx + cpy * cpy + cpz * cpz);
            cpx *= 1.0f / len;
            cpy *= 1.0f / len;
            cpz *= 1.0f / len;
            len = Math.min(len, 32.0f);
            cpx *= len;
            cpy *= len;
            cpz *= len;
            int quadCount = translucentData.getVertexData().getLength() / (formatSize * 4);
            int quadId = 0;
            long[] srcs = new long[7];
            long[] sortingData = new long[quadCount];
            int[] ranges = SodiumResultCompatibility.computeRanges(translucentData.getVertexSegments());
            for (i = 0; i < ModelQuadFacing.COUNT; ++i) {
                long src;
                int off = ranges[i * 2];
                int count = ranges[i * 2 + 1];
                srcs[i] = src = MemoryUtil.memAddress((ByteBuffer)translucentData.getVertexData().getDirectBuffer()) + (long)off * (long)formatSize;
                float cx = 0.0f;
                float cy = 0.0f;
                float cz = 0.0f;
                for (int j = 0; j < count; ++j) {
                    float z;
                    float y;
                    float x;
                    long base = src + (long)j * (long)formatSize;
                    if (Nvidium.config.use_sodium_vertex_format) {
                        int hi = MemoryUtil.memGetInt((long)base);
                        int lo = MemoryUtil.memGetInt((long)(base + 4L));
                        x = SodiumResultCompatibility.scalePos((hi >> 0 & 0x3FF) << 10 | lo >> 0 & 0x3FF);
                        y = SodiumResultCompatibility.scalePos((hi >> 10 & 0x3FF) << 10 | lo >> 10 & 0x3FF);
                        z = SodiumResultCompatibility.scalePos((hi >> 20 & 0x3FF) << 10 | lo >> 20 & 0x3FF);
                    } else {
                        x = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)base));
                        y = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)(base + 2L)));
                        z = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)(base + 4L)));
                    }
                    SodiumResultCompatibility.updateSectionBounds(min, max, base);
                    cx += x;
                    cy += y;
                    cz += z;
                    if ((j & 3) != 3) continue;
                    float dx = (cx *= 0.25f) - cpx;
                    float dy = (cy *= 0.25f) - cpy;
                    float dz = (cz *= 0.25f) - cpz;
                    float dist = dx * dx + dy * dy + dz * dz;
                    int sortDistance = (int)(dist * 4096.0f);
                    long packedSortingData = (long)sortDistance << 32 | ((long)j >> 2 << 3 | (long)i);
                    sortingData[quadId++] = packedSortingData;
                    cx = 0.0f;
                    cy = 0.0f;
                    cz = 0.0f;
                }
            }
            if (quadId != sortingData.length) {
                throw new IllegalStateException();
            }
            LongArrays.radixSort((long[])sortingData);
            for (i = 0; i < sortingData.length; ++i) {
                long data = sortingData[i];
                SodiumResultCompatibility.copyQuad(srcs[(int)(data & 7L)] + (data >> 3 & 0x1FFFFFFFL) * 4L * (long)formatSize, outPtr + (long)(sortingData.length - 1 - i) * 4L * (long)formatSize);
            }
            offset += quadCount;
        }
        outOffsets[7] = (short)offset;
        BuiltSectionMeshParts solid = (BuiltSectionMeshParts)result.meshes.get(DefaultTerrainRenderPasses.SOLID);
        BuiltSectionMeshParts cutout = (BuiltSectionMeshParts)result.meshes.get(DefaultTerrainRenderPasses.CUTOUT);
        int[] solidRanges = solid != null ? SodiumResultCompatibility.computeRanges(solid.getVertexSegments()) : null;
        int[] cutoutRanges = cutout != null ? SodiumResultCompatibility.computeRanges(cutout.getVertexSegments()) : null;
        for (int i = 0; i < ModelQuadFacing.COUNT; ++i) {
            int poff = offset;
            if (solid != null) {
                offset += SodiumResultCompatibility.copyRange(solid, solidRanges[i * 2], solidRanges[i * 2 + 1], outPtr + (long)offset * 4L * (long)formatSize, formatSize, min, max);
            }
            if (cutout != null) {
                offset += SodiumResultCompatibility.copyRange(cutout, cutoutRanges[i * 2], cutoutRanges[i * 2 + 1], outPtr + (long)offset * 4L * (long)formatSize, formatSize, min, max);
            }
            outOffsets[i] = (short)(offset - poff);
        }
        if (offset * 4 * formatSize != output.getLength()) {
            throw new IllegalStateException("Nvidium bad build result got " + offset * 4 * formatSize + " instead of " + output.getLength() + " at " + result.render.getChunkX() + " " + result.render.getChunkY() + " " + result.render.getChunkZ());
        }
    }

    private static float decodePosition(short v) {
        return (float)Short.toUnsignedInt(v) * 4.8828125E-4f - 8.0f;
    }

    private static float scalePos(int pos) {
        float vertexScale = 3.0517607E-5f;
        return (float)pos * vertexScale - 8.0f;
    }

    private static void updateSectionBounds(Vector3i min, Vector3i max, long vertex) {
        float z;
        float y;
        float x;
        if (Nvidium.config.use_sodium_vertex_format) {
            int hi = MemoryUtil.memGetInt((long)vertex);
            int lo = MemoryUtil.memGetInt((long)(vertex + 4L));
            x = SodiumResultCompatibility.scalePos((hi >> 0 & 0x3FF) << 10 | lo >> 0 & 0x3FF);
            y = SodiumResultCompatibility.scalePos((hi >> 10 & 0x3FF) << 10 | lo >> 10 & 0x3FF);
            z = SodiumResultCompatibility.scalePos((hi >> 20 & 0x3FF) << 10 | lo >> 20 & 0x3FF);
        } else {
            x = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)vertex));
            y = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)(vertex + 2L)));
            z = SodiumResultCompatibility.decodePosition(MemoryUtil.memGetShort((long)(vertex + 4L)));
        }
        SodiumResultCompatibility.updateSectionBounds(min, max, x, y, z);
    }

    private static void updateSectionBounds(Vector3i min, Vector3i max, float x, float y, float z) {
        min.x = (int)Math.min((double)min.x, Math.floor(x));
        min.y = (int)Math.min((double)min.y, Math.floor(y));
        min.z = (int)Math.min((double)min.z, Math.floor(z));
        max.x = (int)Math.max((double)max.x, Math.ceil(x));
        max.y = (int)Math.max((double)max.y, Math.ceil(y));
        max.z = (int)Math.max((double)max.z, Math.ceil(z));
    }
}

