/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties.overlay;

import java.util.Locale;
import java.util.Properties;
import me.pepperbell.continuity.client.ContinuityClient;
import net.minecraft.class_11515;
import net.minecraft.class_151;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class OverlayPropertiesSection {
    protected Properties properties;
    protected class_2960 resourceId;
    protected String packId;
    protected int tintIndex = -1;
    @Nullable
    protected class_2680 tintBlock;
    protected class_11515 layer = class_11515.field_60924;

    public OverlayPropertiesSection(Properties properties, class_2960 resourceId, String packId) {
        this.properties = properties;
        this.resourceId = resourceId;
        this.packId = packId;
    }

    public void init() {
        this.parseTintIndex();
        this.parseTintBlock();
        this.parseLayer();
    }

    protected void parseTintIndex() {
        String tintIndexStr = this.properties.getProperty("tintIndex");
        if (tintIndexStr == null) {
            return;
        }
        try {
            int tintIndex = Integer.parseInt(tintIndexStr.trim());
            if (tintIndex >= 0) {
                this.tintIndex = tintIndex;
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ContinuityClient.LOGGER.warn("Invalid 'tintIndex' value '" + tintIndexStr + "' in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
    }

    protected void parseTintBlock() {
        String tintBlockStr = this.properties.getProperty("tintBlock");
        if (tintBlockStr == null) {
            return;
        }
        String[] parts = tintBlockStr.trim().split(":", 3);
        if (parts.length != 0) {
            class_2960 blockId;
            try {
                blockId = parts.length == 1 || parts[1].contains("=") ? class_2960.method_60656((String)parts[0]) : class_2960.method_60655((String)parts[0], (String)parts[1]);
            }
            catch (class_151 e) {
                ContinuityClient.LOGGER.warn("Invalid 'tintBlock' value '" + tintBlockStr + "' in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'", (Throwable)e);
                return;
            }
            if (class_7923.field_41175.method_10250(blockId)) {
                class_2248 block = (class_2248)class_7923.field_41175.method_63535(blockId);
                this.tintBlock = block.method_9564();
            } else {
                ContinuityClient.LOGGER.warn("Unknown block '" + String.valueOf(blockId) + "' in 'tintBlock' value '" + tintBlockStr + "' in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
            }
        } else {
            ContinuityClient.LOGGER.warn("Invalid 'tintBlock' value '" + tintBlockStr + "' in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
        }
    }

    protected void parseLayer() {
        String layerStr1;
        String layerStr = this.properties.getProperty("layer");
        if (layerStr == null) {
            return;
        }
        switch (layerStr1 = layerStr.trim().toLowerCase(Locale.ROOT)) {
            case "cutout_mipped": {
                this.layer = class_11515.field_60924;
                break;
            }
            case "cutout": {
                this.layer = class_11515.field_60925;
                break;
            }
            case "translucent": {
                this.layer = class_11515.field_60926;
                break;
            }
            default: {
                ContinuityClient.LOGGER.warn("Unknown 'layer' value '" + layerStr + " in file '" + String.valueOf(this.resourceId) + "' in pack '" + this.packId + "'");
            }
        }
    }

    public int getTintIndex() {
        return this.tintIndex;
    }

    @Nullable
    public class_2680 getTintBlock() {
        return this.tintBlock;
    }

    public class_11515 getLayer() {
        return this.layer;
    }

    public static interface Provider {
        public OverlayPropertiesSection getOverlayPropertiesSection();
    }
}

