/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.elementa.components.image;

import dev.dediamondpro.resourcify.libs.elementa.components.image.ImageCache;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.util.concurrent.TimeUnit;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\fH\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J)\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00040\u00182\u0006\u0010\u0017\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ \u0010\u001d\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u000eH\u0096\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ'\u0010 \u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b \u0010!J\u0019\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#*\u00020\"H\u0002\u00a2\u0006\u0004\b%\u0010&J\u001d\u0010(\u001a\u0004\u0018\u00010\u0019*\u00020$2\u0006\u0010'\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010+\u001a\u0004\u0018\u00010\u0019*\u00020\"2\u0006\u0010*\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b+\u0010,R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010-R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010.R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010/R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u00100\u00a8\u00061"}, d2={"Ldev/dediamondpro/resourcify/libs/elementa/components/image/FileImageCache;", "Ldev/dediamondpro/resourcify/libs/elementa/components/image/ImageCache;", "Ljava/io/File;", "directory", "", "cacheTime", "Ljava/util/concurrent/TimeUnit;", "timeUnit", "", "deleteOnCacheMiss", "<init>", "(Ljava/io/File;JLjava/util/concurrent/TimeUnit;Z)V", "Ljava/net/URL;", "url", "Ljava/awt/image/BufferedImage;", "get", "(Ljava/net/URL;)Ljava/awt/image/BufferedImage;", "", "hashCode", "index", "", "moveDown", "(II)V", "file", "Lkotlin/Triple;", "", "readEntry", "(Ljava/io/File;)Lkotlin/Triple;", "image", "set", "(Ljava/net/URL;Ljava/awt/image/BufferedImage;)V", "img", "writeEntry", "(Ljava/io/File;Ljava/awt/image/BufferedImage;Ljava/net/URL;)V", "Lorg/w3c/dom/NodeList;", "Lkotlin/sequences/Sequence;", "Lorg/w3c/dom/Node;", "asSequence", "(Lorg/w3c/dom/NodeList;)Lkotlin/sequences/Sequence;", "name", "attributeValue", "(Lorg/w3c/dom/Node;Ljava/lang/String;)Ljava/lang/String;", "keyword", "findValueByKeyword", "(Lorg/w3c/dom/NodeList;Ljava/lang/String;)Ljava/lang/String;", "J", "Z", "Ljava/io/File;", "Ljava/util/concurrent/TimeUnit;", "Elementa"})
@SourceDebugExtension(value={"SMAP\nFileImageCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileImageCache.kt\ngg/essential/elementa/components/image/FileImageCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class FileImageCache
implements ImageCache {
    @NotNull
    private final File directory;
    private final long cacheTime;
    @NotNull
    private final TimeUnit timeUnit;
    private final boolean deleteOnCacheMiss;

    public FileImageCache(@NotNull File directory, long cacheTime, @NotNull TimeUnit timeUnit, boolean deleteOnCacheMiss) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        this.directory = directory;
        this.cacheTime = cacheTime;
        this.timeUnit = timeUnit;
        this.deleteOnCacheMiss = deleteOnCacheMiss;
        if (!this.directory.exists()) {
            this.directory.mkdirs();
        }
        if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("Directory " + this.directory.getAbsolutePath() + " is not a valid directory for a FileImageCache");
        }
    }

    public /* synthetic */ FileImageCache(File file, long l, TimeUnit timeUnit, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = true;
        }
        this(file, l, timeUnit, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public BufferedImage get(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        hashCode = url.hashCode();
        index = 0;
        var4_4 = FileChannel.open(new File(this.directory, "" + hashCode + '-' + index + ".png").toPath(), new OpenOption[0]);
        var5_5 = null;
        try {
            open = (FileChannel)var4_4;
            $i$a$-use-FileImageCache$get$1 = false;
            lock = open.lock();
            while (true) {
                if (!(file = new File(this.directory, "" + hashCode + '-' + index + ".png")).exists()) {
                    lock.release();
                    var12_13 = null;
                    return var12_13;
                }
                cacheItem = this.readEntry(file);
                if (!Intrinsics.areEqual((Object)cacheItem.getSecond(), (Object)url.toString())) ** GOTO lbl28
                if (System.currentTimeMillis() - ((Number)cacheItem.getThird()).longValue() < this.timeUnit.toMillis(this.cacheTime)) {
                    lock.release();
                    var11_14 = (BufferedImage)cacheItem.getFirst();
                    return var11_14;
                }
                if (this.deleteOnCacheMiss) {
                    file.delete();
                    this.moveDown(hashCode, index);
                }
lbl28:
                // 4 sources

                ++index;
                continue;
                break;
            }
            catch (Throwable var6_7) {
                var5_5 = var6_7;
                throw var6_7;
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)var4_4, (Throwable)var5_5);
        }
    }

    @Override
    public void set(@NotNull URL url, @NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        int hashCode = url.hashCode();
        int index = 0;
        while (true) {
            File file;
            if (!(file = new File(this.directory, "" + hashCode + '-' + index + ".png")).exists()) {
                this.writeEntry(file, image, url);
                return;
            }
            ++index;
        }
    }

    private final void moveDown(int hashCode, int index) {
        int tmp = index + 1;
        File src;
        while ((src = new File(this.directory, "" + hashCode + '-' + tmp + ".png")).exists()) {
            src.renameTo(new File(this.directory, "" + hashCode + '-' + (tmp - 1) + ".png"));
            ++tmp;
        }
        return;
    }

    private final void writeEntry(File file, BufferedImage img, URL url) {
        ImageWriter writer = ImageIO.getImageWritersByFormatName("png").next();
        ImageWriteParam writeParam = writer.getDefaultWriteParam();
        ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
        IIOMetadataNode urlEntry = new IIOMetadataNode("tEXtEntry");
        urlEntry.setAttribute("keyword", "image_url");
        urlEntry.setAttribute("value", url.toString());
        IIOMetadataNode cacheTimeEntry = new IIOMetadataNode("tEXtEntry");
        cacheTimeEntry.setAttribute("keyword", "cache_time");
        cacheTimeEntry.setAttribute("value", String.valueOf(System.currentTimeMillis()));
        IIOMetadataNode text = new IIOMetadataNode("tEXt");
        text.appendChild(urlEntry);
        text.appendChild(cacheTimeEntry);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_png_1.0");
        root.appendChild(text);
        metadata.mergeTree("javax_imageio_png_1.0", root);
        FileOutputStream fos = new FileOutputStream(file);
        ImageOutputStream stream = ImageIO.createImageOutputStream(fos);
        writer.setOutput(stream);
        writer.write(metadata, new IIOImage(img, null, metadata), writeParam);
        stream.close();
        fos.close();
    }

    private final Triple<BufferedImage, String, Long> readEntry(File file) {
        Object v1;
        byte[] imageData;
        block2: {
            Sequence<Node> sequence;
            ImageReader imageReader = ImageIO.getImageReadersByFormatName("png").next();
            imageData = FilesKt.readBytes((File)file);
            imageReader.setInput(ImageIO.createImageInputStream(new ByteArrayInputStream(imageData)), true);
            Node metadata = imageReader.getImageMetadata(0).getAsTree("javax_imageio_1.0");
            NodeList nodeList = metadata.getChildNodes();
            Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"metadata.childNodes");
            Sequence<Node> sequence2 = sequence = this.asSequence(nodeList);
            for (Object e : sequence2) {
                Node it = (Node)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getNodeName(), (Object)"Text")) continue;
                v1 = e;
                break block2;
            }
            v1 = null;
        }
        Intrinsics.checkNotNull(v1);
        NodeList nodeList = ((Node)v1).getChildNodes();
        Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"metadata.childNodes.asSe\u2026 == \"Text\" }!!.childNodes");
        NodeList childNodes = nodeList;
        String string = this.findValueByKeyword(childNodes, "image_url");
        if (string == null) {
            string = "";
        }
        String cacheUrl = string;
        String string2 = this.findValueByKeyword(childNodes, "cache_time");
        long timeCached = string2 != null ? Long.parseLong(string2) : 0L;
        return new Triple((Object)ImageIO.read(new ByteArrayInputStream(imageData)), (Object)cacheUrl, (Object)timeCached);
    }

    private final Sequence<Node> asSequence(NodeList $this$asSequence) {
        return SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)0, (int)$this$asSequence.getLength()))), (Function1)((Function1)new Function1<Integer, Node>($this$asSequence){
            final /* synthetic */ NodeList $this_asSequence;
            {
                this.$this_asSequence = $receiver;
                super(1);
            }

            public final Node invoke(int it) {
                return this.$this_asSequence.item(it);
            }
        }));
    }

    private final String attributeValue(Node $this$attributeValue, String name) {
        Node node2 = $this$attributeValue.getAttributes().getNamedItem(name);
        return node2 != null ? node2.getNodeValue() : null;
    }

    private final String findValueByKeyword(NodeList $this$findValueByKeyword, String keyword) {
        Object v0;
        block1: {
            Sequence<Node> sequence;
            Sequence<Node> sequence2 = sequence = this.asSequence($this$findValueByKeyword);
            for (Object e : sequence2) {
                Node it = (Node)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)this.attributeValue(it, "keyword"), (Object)keyword)) continue;
                v0 = e;
                break block1;
            }
            v0 = null;
        }
        Node node2 = v0;
        return node2 != null ? this.attributeValue(node2, "value") : null;
    }
}

