/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark.elements.formatting.impl;

import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.Element;
import dev.dediamondpro.resourcify.libs.minemark.elements.formatting.FormattingElement;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import dev.dediamondpro.resourcify.libs.minemark.utils.ColorFactory;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public class CssStyleElement<S extends Style, R>
implements FormattingElement<S, R> {
    protected final List<String> supportedProperties = new ArrayList<String>(){
        {
            this.add("color");
            this.add("text-align");
            this.add("text-decoration");
            this.add("font-size");
        }
    };

    @Override
    public void applyStyle(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @NotNull Attributes attributes) {
        String[] parts;
        String inlineCss = attributes.getValue("style");
        if (inlineCss == null) {
            return;
        }
        block30: for (String part : parts = inlineCss.split(";")) {
            String[] propertyValue = part.split(":");
            if (propertyValue.length != 2) continue;
            String property = propertyValue[0].trim();
            String value = propertyValue[1].trim();
            switch (property) {
                case "color": {
                    layoutStyle.set(LayoutStyle.TEXT_COLOR, ColorFactory.web(value));
                    continue block30;
                }
                case "text-align": {
                    switch (value.toLowerCase()) {
                        case "left": {
                            layoutStyle.set(LayoutStyle.ALIGNMENT, LayoutStyle.Alignment.LEFT);
                            break;
                        }
                        case "center": {
                            layoutStyle.set(LayoutStyle.ALIGNMENT, LayoutStyle.Alignment.CENTER);
                            break;
                        }
                        case "right": {
                            layoutStyle.set(LayoutStyle.ALIGNMENT, LayoutStyle.Alignment.RIGHT);
                        }
                    }
                    continue block30;
                }
                case "text-decoration": {
                    String[] stringArray = value.split(" ");
                    int n = stringArray.length;
                    block31: for (int j = 0; j < n; ++j) {
                        String decoration;
                        switch (decoration = stringArray[j]) {
                            case "underline": {
                                layoutStyle.set(LayoutStyle.UNDERLINED, true);
                                continue block31;
                            }
                            case "line-through": {
                                layoutStyle.set(LayoutStyle.STRIKETHROUGH, true);
                            }
                        }
                    }
                    continue block30;
                }
                case "font-size": {
                    Float fontSize = null;
                    if (value.endsWith("px")) {
                        fontSize = Float.valueOf(style.getTextStyle().adaptFontSize(Float.parseFloat(value.substring(0, value.length() - 2))));
                    } else if (value.endsWith("%")) {
                        fontSize = Float.valueOf(layoutStyle.get(LayoutStyle.FONT_SIZE).floatValue() * (Float.parseFloat(value.substring(0, value.length() - 1)) / 100.0f));
                    }
                    if (fontSize == null) continue block30;
                    layoutStyle.set(LayoutStyle.FONT_SIZE, fontSize);
                }
            }
        }
    }

    @Override
    public boolean canBeInline(S style, LayoutStyle layoutStyle, @NotNull Element<S, R> parent, @NotNull String qName, @NotNull Attributes attributes) {
        return !attributes.getValue("style").contains("text-align");
    }

    @Override
    public boolean appliesTo(S style, LayoutStyle layoutStyle, @NotNull Element<S, R> parent, @NotNull String qName, @NotNull Attributes attributes) {
        String styleCss = attributes.getValue("style");
        if (styleCss == null) {
            return false;
        }
        for (String property : this.supportedProperties) {
            if (!styleCss.contains(property)) continue;
            return true;
        }
        return false;
    }
}

