/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.universal;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.dediamondpro.resourcify.libs.universal.ChatColor;
import dev.dediamondpro.resourcify.libs.universal.UMatrixStack;
import dev.dediamondpro.resourcify.libs.universal.UMinecraft;
import dev.dediamondpro.resourcify.libs.universal.render.DrawCallBuilder;
import dev.dediamondpro.resourcify.libs.universal.render.ScissorState;
import dev.dediamondpro.resourcify.libs.universal.render.URenderPass;
import dev.dediamondpro.resourcify.libs.universal.render.URenderPipeline;
import dev.dediamondpro.resourcify.libs.universal.utils.ReleasedDynamicTexture;
import dev.dediamondpro.resourcify.libs.universal.vertex.UBuiltBuffer;
import dev.dediamondpro.resourcify.libs.universal.vertex.UVertexConsumer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_1060;
import net.minecraft.class_10868;
import net.minecraft.class_11719;
import net.minecraft.class_11767;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4588;
import net.minecraft.class_5225;
import net.minecraft.class_5348;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.opengl.GL11;

public class UGraphics {
    private static final Pattern formattingCodePattern = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static UMatrixStack UNIT_STACK = UMatrixStack.UNIT;
    public static class_2583 EMPTY_WITH_FONT_ID = class_2583.field_24360.method_27704((class_11719)new class_11719.class_11721(class_2960.method_60655((String)"minecraft", (String)"alt")));
    public static int ZERO_TEXT_ALPHA = 10;
    private class_287 instance;
    private VertexFormat vertexFormat;
    private static final class_327.class_6415 TEXT_LAYER_TYPE = class_327.class_6415.field_33993;
    private static final class_9799 SORTED_QUADS_ALLOCATOR = new class_9799(65536);
    @ApiStatus.Internal
    public static final Map<VertexFormat, String> DEFAULT_SHADERS = new HashMap<VertexFormat, String>();
    private class_1921 renderLayer;

    public UGraphics(class_287 instance) {
        this.instance = instance;
    }

    public UVertexConsumer asUVertexConsumer() {
        return UVertexConsumer.of((class_4588)this.instance);
    }

    public static UGraphics getFromTessellator() {
        return new UGraphics(null);
    }

    public static class_289 getTessellator() {
        return class_289.method_1348();
    }

    public static boolean isCoreProfile() {
        return true;
    }

    @Deprecated
    public static void enableStencil() {
    }

    @Deprecated
    public static void cullFace(int mode) {
    }

    public static void enableLighting() {
    }

    public static void disableLighting() {
    }

    public static void disableLight(int mode) {
    }

    public static void enableLight(int mode) {
    }

    @Deprecated
    public static void enableBlend() {
    }

    @Deprecated
    public static void disableTexture2D() {
    }

    public static void disableAlpha() {
    }

    public static void alphaFunc(int func, float ref) {
    }

    public static void shadeModel(int mode) {
    }

    @Deprecated
    public static void blendEquation(int equation) {
    }

    @Deprecated
    public static void tryBlendFuncSeparate(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
    }

    @Deprecated
    public static void enableTexture2D() {
    }

    @Deprecated
    public static void disableBlend() {
    }

    public static void deleteTexture(int glTextureId) {
        GL11.glDeleteTextures((int)glTextureId);
    }

    public static void enableAlpha() {
    }

    public static void configureTexture(int glTextureId, Runnable block) {
        int prevTextureBinding = GL11.glGetInteger((int)32873);
        GlStateManager._bindTexture((int)glTextureId);
        block.run();
        GlStateManager._bindTexture((int)prevTextureBinding);
    }

    public static void configureTextureUnit(int index, Runnable block) {
        int prevActiveTexture = UGraphics.getActiveTexture();
        UGraphics.setActiveTexture(33984 + index);
        block.run();
        UGraphics.setActiveTexture(prevActiveTexture);
    }

    @Deprecated
    public static void activeTexture(int glId) {
        UGraphics.setActiveTexture(glId);
    }

    public static int getActiveTexture() {
        return GL11.glGetInteger((int)34016);
    }

    public static void setActiveTexture(int glId) {
        GlStateManager._activeTexture((int)glId);
    }

    @Deprecated
    public static void bindTexture(int glTextureId) {
        UGraphics.bindTexture(UGraphics.getActiveTexture() - 33984, glTextureId);
    }

    @Deprecated
    public static void bindTexture(class_2960 resourceLocation) {
        UGraphics.bindTexture(UGraphics.getOrLoadTextureId(resourceLocation));
    }

    public static void bindTexture(int index, int glTextureId) {
        RenderSystem.setShaderTexture((int)index, (GpuTextureView)RenderSystem.getDevice().createTextureView((GpuTexture)new UnownedGlTexture(glTextureId)));
    }

    public static void bindTexture(int index, class_2960 resourceLocation) {
        UGraphics.bindTexture(index, UGraphics.getOrLoadTextureId(resourceLocation));
    }

    private static int getOrLoadTextureId(class_2960 resourceLocation) {
        class_1060 textureManager = UMinecraft.getMinecraft().method_1531();
        class_1044 texture2 = textureManager.method_4619(resourceLocation);
        if (texture2 == null) {
            texture2 = new class_1049(resourceLocation);
            textureManager.method_4616(resourceLocation, texture2);
        }
        return ((class_10868)texture2.method_68004()).method_68427();
    }

    public static int getStringWidth(String in) {
        return UMinecraft.getFontRenderer().method_1727(in);
    }

    public static int getFontHeight() {
        Objects.requireNonNull(UMinecraft.getFontRenderer());
        return 9;
    }

    @Deprecated
    public static void drawString(String text, float x, float y, int color, boolean shadow) {
        UGraphics.drawString(UNIT_STACK, text, x, y, color, shadow);
    }

    public static void drawString(UMatrixStack stack, String text, float x, float y, int color, boolean shadow) {
        if ((color >> 24 & 0xFF) <= 10) {
            return;
        }
        GlyphDrawerImpl drawerImpl = new GlyphDrawerImpl(stack.peek().getModel());
        UMinecraft.getFontRenderer().method_71796(text, x, y, color, shadow, 0).method_71801((class_327.class_11464)drawerImpl);
        drawerImpl.flush();
    }

    @Deprecated
    public static void drawString(String text, float x, float y, int color, int shadowColor) {
        UGraphics.drawString(UNIT_STACK, text, x, y, color, shadowColor);
    }

    public static void drawString(UMatrixStack stack, String text, float x, float y, int color, int shadowColor) {
        if ((color >> 24 & 0xFF) <= 10) {
            return;
        }
        String shadowText = ChatColor.Companion.stripColorCodes(text);
        GlyphDrawerImpl drawerImpl = new GlyphDrawerImpl(stack.peek().getModel());
        UMinecraft.getFontRenderer().method_71796(shadowText, x + 1.0f, y + 1.0f, shadowColor, false, 0).method_71801((class_327.class_11464)drawerImpl);
        drawerImpl.matrix = drawerImpl.matrix.translate(0.0f, 0.0f, 0.03f, new Matrix4f());
        UMinecraft.getFontRenderer().method_71796(text, x, y, color, false, 0).method_71801((class_327.class_11464)drawerImpl);
        drawerImpl.flush();
    }

    public static List<String> listFormattedStringToWidth(String str, int wrapWidth) {
        return UGraphics.listFormattedStringToWidth(str, wrapWidth, true);
    }

    public static List<String> listFormattedStringToWidth(String str, int wrapWidth, boolean safe) {
        if (safe) {
            String tmp = formattingCodePattern.matcher(str).replaceAll("");
            int max = 0;
            for (String s : tmp.split(" ")) {
                max = Math.max(max, UGraphics.getStringWidth(s));
            }
            wrapWidth = Math.max(max, wrapWidth);
        }
        ArrayList<String> strings = new ArrayList<String>();
        class_5225 charManager = UMinecraft.getFontRenderer().method_27527();
        class_5348 properties2 = charManager.method_27490((class_5348)class_2561.method_43470((String)str).method_27696(EMPTY_WITH_FONT_ID), wrapWidth, class_2583.field_24360);
        properties2.method_27657(string -> {
            strings.add(string);
            return Optional.empty();
        });
        return strings;
    }

    public static float getCharWidth(char character) {
        return UGraphics.getStringWidth(String.valueOf(character));
    }

    public static void clearColor(float r, float g, float b, float a) {
        GL11.glClearColor((float)r, (float)g, (float)b, (float)a);
    }

    public static void clearDepth(double depth) {
        GL11.glClearDepth((double)depth);
    }

    public static void glClear(int mode) {
        GL11.glClear((int)mode);
    }

    public static void glClearStencil(int mode) {
        GL11.glClearStencil((int)mode);
    }

    public static ReleasedDynamicTexture getTexture(InputStream stream) {
        try {
            return new ReleasedDynamicTexture(class_1011.method_4309((InputStream)stream));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to read image");
        }
    }

    public static ReleasedDynamicTexture getTexture(BufferedImage img) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", baos);
            return new ReleasedDynamicTexture(class_1011.method_4309((InputStream)new ByteArrayInputStream(baos.toByteArray())));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to create texture");
        }
    }

    public static ReleasedDynamicTexture getEmptyTexture() {
        return new ReleasedDynamicTexture(0, 0);
    }

    public static void glUseProgram(int program) {
        GlStateManager._glUseProgram((int)program);
    }

    public static boolean isOpenGl21Supported() {
        return true;
    }

    public static boolean areShadersSupported() {
        return true;
    }

    public static int glCreateProgram() {
        return GlStateManager.glCreateProgram();
    }

    public static int glCreateShader(int type2) {
        return GlStateManager.glCreateShader((int)type2);
    }

    public static void glCompileShader(int shaderIn) {
        GlStateManager.glCompileShader((int)shaderIn);
    }

    public static int glGetShaderi(int shaderIn, int pname) {
        return GlStateManager.glGetShaderi((int)shaderIn, (int)pname);
    }

    public static String glGetShaderInfoLog(int shader, int maxLen) {
        return GlStateManager.glGetShaderInfoLog((int)shader, (int)maxLen);
    }

    public static void glAttachShader(int program, int shaderIn) {
        GlStateManager.glAttachShader((int)program, (int)shaderIn);
    }

    public static void glLinkProgram(int program) {
        GlStateManager.glLinkProgram((int)program);
    }

    public static int glGetProgrami(int program, int pname) {
        return GlStateManager.glGetProgrami((int)program, (int)pname);
    }

    public static String glGetProgramInfoLog(int program, int maxLen) {
        return GlStateManager.glGetProgramInfoLog((int)program, (int)maxLen);
    }

    public static void color4f(float red, float green, float blue, float alpha) {
    }

    public static void directColor3f(float red, float green, float blue) {
        UGraphics.color4f(red, green, blue, 1.0f);
    }

    @Deprecated
    public static void enableDepth() {
    }

    @Deprecated
    public static void depthFunc(int mode) {
    }

    @Deprecated
    public static void depthMask(boolean flag) {
    }

    @Deprecated
    public static void disableDepth() {
    }

    public static void enableScissor(int x, int y, int width, int height) {
        new ScissorState(true, x, y, width, height).activate();
    }

    public static void disableScissor() {
        new ScissorState(false, 0, 0, 0, 0).activate();
    }

    @Deprecated
    public UGraphics beginWithActiveShader(DrawMode mode, CommonVertexFormats format) {
        return this.beginWithActiveShader(mode, format.mc);
    }

    @Deprecated
    public UGraphics beginWithActiveShader(DrawMode mode, VertexFormat format) {
        return this.beginInternal(mode, format);
    }

    private UGraphics beginInternal(DrawMode mode, VertexFormat format) {
        this.vertexFormat = format;
        this.instance = UGraphics.getTessellator().method_60827(mode.mcMode, format);
        return this;
    }

    @Deprecated
    public UGraphics beginWithDefaultShader(DrawMode mode, CommonVertexFormats format) {
        return this.beginWithDefaultShader(mode, format.mc);
    }

    @Deprecated
    public UGraphics beginWithDefaultShader(DrawMode mode, VertexFormat format) {
        return this.beginWithActiveShader(mode, format);
    }

    public UGraphics beginRenderLayer(class_1921 renderLayer) {
        this.renderLayer = renderLayer;
        this.beginInternal(DrawMode.fromRenderLayer(renderLayer), renderLayer.method_23031());
        return this;
    }

    @Deprecated
    public UGraphics begin(int glMode, CommonVertexFormats format) {
        return this.begin(glMode, format.mc);
    }

    @Deprecated
    public UGraphics begin(int glMode, VertexFormat format) {
        this.beginWithDefaultShader(DrawMode.fromGl(glMode), format);
        return this;
    }

    public void drawDirect() {
        class_9801 builtBuffer = this.instance.method_60794();
        if (builtBuffer == null) {
            return;
        }
        if (this.renderLayer != null) {
            this.renderLayer.method_60895(builtBuffer);
            return;
        }
        this.doDraw(builtBuffer);
    }

    public void drawSorted(int cameraX, int cameraY, int cameraZ) {
        class_9801 builtBuffer = this.instance.method_60794();
        if (builtBuffer == null) {
            return;
        }
        builtBuffer.method_60819(SORTED_QUADS_ALLOCATOR, RenderSystem.getProjectionType().method_65045());
        if (this.renderLayer != null) {
            this.renderLayer.method_60895(builtBuffer);
            return;
        }
        this.doDraw(builtBuffer);
    }

    private void doDraw(class_9801 builtBuffer) {
        throw new UnsupportedOperationException("Drawing via UGraphics on 1.21.5+ is only supported via `beginRenderLayer`. Use that or `UBufferBulider`/`URenderPipeline` instead.");
    }

    @Deprecated
    public UGraphics pos(double x, double y, double z) {
        return this.pos(UNIT_STACK, x, y, z);
    }

    public UGraphics pos(UMatrixStack stack, double x, double y, double z) {
        if (stack == UNIT_STACK) {
            this.instance.method_22912((float)x, (float)y, (float)z);
        } else {
            this.instance.method_22918(stack.peek().getModel(), (float)x, (float)y, (float)z);
        }
        return this;
    }

    @Deprecated
    public UGraphics norm(float x, float y, float z) {
        return this.norm(UNIT_STACK, x, y, z);
    }

    public UGraphics norm(UMatrixStack stack, float x, float y, float z) {
        if (stack == UNIT_STACK) {
            this.instance.method_22914(x, y, z);
        } else {
            Vector3f normal = stack.peek().getNormal().transform(x, y, z, new Vector3f());
            this.instance.method_22914(normal.x(), normal.y(), normal.z());
        }
        return this;
    }

    public UGraphics color(int red, int green, int blue, int alpha) {
        return this.color((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public UGraphics color(float red, float green, float blue, float alpha) {
        this.instance.method_22915(red, green, blue, alpha);
        return this;
    }

    public UGraphics color(Color color) {
        return this.color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public UGraphics endVertex() {
        return this;
    }

    public UGraphics tex(double u, double v) {
        this.instance.method_22913((float)u, (float)v);
        return this;
    }

    public UGraphics overlay(int u, int v) {
        this.instance.method_60796(u, v);
        return this;
    }

    public UGraphics light(int u, int v) {
        this.instance.method_22921(u, v);
        return this;
    }

    static {
        DEFAULT_SHADERS.put(class_290.field_29337, "core/rendertype_lines");
        DEFAULT_SHADERS.put(class_290.field_1584, "core/particle");
        DEFAULT_SHADERS.put(class_290.field_1592, "core/position");
        DEFAULT_SHADERS.put(class_290.field_1576, "core/position_color");
        DEFAULT_SHADERS.put(class_290.field_21468, "core/position_color_lightmap");
        DEFAULT_SHADERS.put(class_290.field_1585, "core/position_tex");
        DEFAULT_SHADERS.put(class_290.field_1575, "core/position_tex_color");
        DEFAULT_SHADERS.put(class_290.field_20888, "core/position_color_tex_lightmap");
    }

    private static class UnownedGlTexture
    extends class_10868 {
        public UnownedGlTexture(int glId) {
            super(4, "", TextureFormat.RGBA8, 0, 0, 0, 1, glId);
            this.field_57884 = false;
        }
    }

    private static class GlyphDrawerImpl
    implements class_327.class_11464 {
        private static final int LIGHT = 0xF000F0;
        private Matrix4f matrix;
        private RenderPipeline pipeline;
        private GpuTextureView texture;
        private class_287 bufferBuilder;

        private GlyphDrawerImpl(Matrix4f matrix) {
            this.matrix = matrix;
        }

        public void flush() {
            if (this.bufferBuilder == null) {
                return;
            }
            RenderPipeline pipeline = this.pipeline;
            GpuTextureView texture2 = this.texture;
            class_287 bufferBuilder = this.bufferBuilder;
            this.pipeline = null;
            this.texture = null;
            this.bufferBuilder = null;
            try (class_9801 builtBuffer = bufferBuilder.method_60794();){
                if (builtBuffer == null) {
                    return;
                }
                GpuTextureView lightTexture = class_310.method_1551().field_1773.method_22974().method_71650();
                try (URenderPass renderPass = new URenderPass();){
                    renderPass.draw(UBuiltBuffer.wrap(builtBuffer), URenderPipeline.wrap(pipeline), (Function1<? super DrawCallBuilder, Unit>)((Function1)builder -> {
                        RenderPass mcRenderPass = ((URenderPass.DrawCallBuilderImpl)builder).getMc();
                        mcRenderPass.bindSampler("Sampler0", texture2);
                        mcRenderPass.bindSampler("Sampler2", lightTexture);
                        return Unit.INSTANCE;
                    }));
                }
            }
        }

        private void draw(class_11767 drawable) {
            if (this.pipeline != drawable.method_73400() || this.texture != drawable.comp_4629()) {
                this.flush();
                this.pipeline = drawable.method_73400();
                this.texture = drawable.comp_4629();
                this.bufferBuilder = class_289.method_1348().method_60827(this.pipeline.getVertexFormatMode(), this.pipeline.getVertexFormat());
            }
            drawable.method_73403(this.matrix, (class_4588)this.bufferBuilder, 0xF000F0, false);
        }

        public void method_71797(class_11767 drawable) {
            this.draw(drawable);
        }

        public void method_71798(class_11767 drawable) {
            this.draw(drawable);
        }
    }

    public static enum CommonVertexFormats {
        POSITION(class_290.field_1592),
        POSITION_COLOR(class_290.field_1576),
        POSITION_TEXTURE(class_290.field_1585),
        POSITION_TEXTURE_COLOR(class_290.field_1575),
        POSITION_COLOR_TEXTURE_LIGHT(class_290.field_1590),
        POSITION_TEXTURE_LIGHT_COLOR(class_290.field_1586),
        POSITION_TEXTURE_COLOR_LIGHT(class_290.field_1584),
        POSITION_TEXTURE_COLOR_NORMAL(class_290.field_1577);

        public final VertexFormat mc;

        private CommonVertexFormats(VertexFormat mc) {
            this.mc = mc;
        }
    }

    public static enum DrawMode {
        LINES(1),
        LINE_STRIP(3),
        TRIANGLES(4),
        TRIANGLE_STRIP(5),
        TRIANGLE_FAN(6),
        QUADS(7);

        public final int glMode;
        public final VertexFormat.class_5596 mcMode;

        private DrawMode(int glMode) {
            this.glMode = glMode;
            this.mcMode = DrawMode.glToMcDrawMode(glMode);
        }

        private static VertexFormat.class_5596 glToMcDrawMode(int glMode) {
            switch (glMode) {
                case 1: {
                    return VertexFormat.class_5596.field_27377;
                }
                case 3: {
                    return VertexFormat.class_5596.field_27378;
                }
                case 4: {
                    return VertexFormat.class_5596.field_27379;
                }
                case 5: {
                    return VertexFormat.class_5596.field_27380;
                }
                case 6: {
                    return VertexFormat.class_5596.field_27381;
                }
                case 7: {
                    return VertexFormat.class_5596.field_27382;
                }
            }
            throw new IllegalArgumentException("Unsupported draw mode " + glMode);
        }

        private static DrawMode fromMc(VertexFormat.class_5596 mcMode) {
            switch (mcMode) {
                case field_27377: {
                    return LINES;
                }
                case field_27378: {
                    return LINE_STRIP;
                }
                case field_27379: {
                    return TRIANGLES;
                }
                case field_27380: {
                    return TRIANGLE_STRIP;
                }
                case field_27381: {
                    return TRIANGLE_FAN;
                }
                case field_27382: {
                    return QUADS;
                }
            }
            throw new IllegalArgumentException("Unsupported draw mode " + String.valueOf(mcMode));
        }

        public static DrawMode fromGl(int glMode) {
            switch (glMode) {
                case 1: {
                    return LINES;
                }
                case 3: {
                    return LINE_STRIP;
                }
                case 4: {
                    return TRIANGLES;
                }
                case 5: {
                    return TRIANGLE_STRIP;
                }
                case 6: {
                    return TRIANGLE_FAN;
                }
                case 7: {
                    return QUADS;
                }
            }
            throw new IllegalArgumentException("Unsupported draw mode " + glMode);
        }

        public static DrawMode fromRenderLayer(class_1921 renderLayer) {
            return DrawMode.fromMc(renderLayer.method_23033());
        }
    }

    public static class Globals {
    }
}

