/*
 * Decompiled with CFR 0.152.
 */
package dynamic_fps.impl.util;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Locale;

public class JsonUtil {
    private static final Gson GSON = new GsonBuilder().setLenient().serializeNulls().setPrettyPrinting().enableComplexMapKeySerialization().registerTypeHierarchyAdapter(Enum.class, new EnumSerializer()).setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();

    public static String toJson(Object object) {
        return GSON.toJson(object);
    }

    public static String toJson(JsonElement element) {
        return GSON.toJson(element);
    }

    public static JsonElement toJsonTree(Object object) {
        return GSON.toJsonTree(object);
    }

    public static <T> T fromJson(String data, Class<T> type) {
        return (T)GSON.fromJson(data, type);
    }

    public static <T> T fromJson(JsonElement data, Class<T> type) {
        return (T)GSON.fromJson(data, type);
    }

    private static final class EnumSerializer<T extends Enum<T>>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        private EnumSerializer() {
        }

        public JsonElement serialize(T instance, Type type, JsonSerializationContext context) {
            return new JsonPrimitive(((Enum)instance).toString().toLowerCase(Locale.ROOT));
        }

        public T deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            try {
                Class<?> class_ = Class.forName(type.getTypeName());
                return (T)Enum.valueOf(class_, element.getAsString().toUpperCase(Locale.ROOT));
            }
            catch (ClassNotFoundException | IllegalArgumentException e) {
                throw new JsonParseException((Throwable)e);
            }
        }
    }
}

