/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features.methods;

import java.util.List;
import net.minecraft.class_1146;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathExpressionParser;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_sound_features.ESF;
import traben.entity_sound_features.ESFConfig;

public class ESFPlaySoundMethodFactory
extends MathMethod {
    private long lastSoundTick = 0L;

    public ESFPlaySoundMethodFactory(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        boolean log = ((ESFConfig)ESF.config().getConfig()).logSoundSetup;
        if (log) {
            ESF.log("creating sound EMF math function definition (no guaranteed failure log messages unless you enable EMF math logging):\n > " + String.valueOf(args));
        }
        try {
            MathComponent range;
            MathComponent pitch;
            MathComponent volume;
            String soundId = args.get(0);
            if (soundId == null || soundId.isBlank()) {
                throw new EMFMathException("Sound event ID invalid");
            }
            class_2960 res = ESF.res(soundId);
            class_1146 event = class_310.method_1551().method_1483().method_4869(res);
            if (event == null) {
                throw new EMFMathException("Sound event not found: " + soundId);
            }
            MathComponent trueForSound = MathExpressionParser.getOptimizedExpression((String)args.get(1), (boolean)false, (EMFAnimation)calculationInstance);
            MathComponent delay = MathExpressionParser.getOptimizedExpression((String)args.get(2), (boolean)false, (EMFAnimation)calculationInstance);
            if (delay == MathExpressionParser.NULL_EXPRESSION || trueForSound == MathExpressionParser.NULL_EXPRESSION) {
                throw new EMFMathException("Invalid arguments");
            }
            if (args.size() == 6) {
                volume = MathExpressionParser.getOptimizedExpression((String)args.get(3), (boolean)false, (EMFAnimation)calculationInstance);
                pitch = MathExpressionParser.getOptimizedExpression((String)args.get(4), (boolean)false, (EMFAnimation)calculationInstance);
                range = MathExpressionParser.getOptimizedExpression((String)args.get(5), (boolean)false, (EMFAnimation)calculationInstance);
                if (volume == MathExpressionParser.NULL_EXPRESSION || pitch == MathExpressionParser.NULL_EXPRESSION) {
                    throw new EMFMathException("Invalid optional arguments");
                }
            } else {
                volume = () -> 1.0f;
                pitch = () -> 1.0f;
                range = () -> 16.0f;
            }
            this.supplier = () -> {
                if (!MathValue.toBoolean((float)trueForSound.getResult())) {
                    return Float.NEGATIVE_INFINITY;
                }
                EMFEntity emfEntity = EMFAnimationEntityContext.getEMFEntity();
                if (emfEntity == null || emfEntity.etf$getWorld() == null) {
                    return Float.NEGATIVE_INFINITY;
                }
                float delayVal = delay.getResult();
                long currentTick = emfEntity.etf$getWorld().method_8510();
                float f = this.lastSoundTick;
                float f2 = delayVal < 1.0f ? 1.0f : delayVal;
                if (f + f2 > (float)currentTick) {
                    return Float.NEGATIVE_INFINITY;
                }
                this.lastSoundTick = currentTick;
                try {
                    class_3419 class_34192;
                    class_1937 class_19372 = emfEntity.etf$getWorld();
                    class_746 class_7462 = class_310.method_1551().field_1724;
                    class_2338 class_23382 = emfEntity.etf$getBlockPos();
                    class_3414 class_34142 = class_3414.method_47909((class_2960)res, (float)class_3532.method_15363((float)range.getResult(), (float)0.0f, (float)128.0f));
                    if (emfEntity instanceof class_1297) {
                        class_1297 entity = (class_1297)emfEntity;
                        class_34192 = entity.method_5634();
                    } else {
                        class_34192 = class_3419.field_15245;
                    }
                    class_19372.method_8396((class_1297)class_7462, class_23382, class_34142, class_34192, class_3532.method_15363((float)volume.getResult(), (float)0.0f, (float)1.0f), class_3532.method_15363((float)pitch.getResult(), (float)0.5f, (float)2.0f));
                    return Float.POSITIVE_INFINITY;
                }
                catch (Exception e) {
                    return Float.NEGATIVE_INFINITY;
                }
            };
            if (log) {
                ESF.log("sound EMF math function definition created successfully for " + String.valueOf(res));
            }
        }
        catch (Exception e) {
            if (log) {
                ESF.log("Error creating sound EMF math function definition: " + e.getMessage());
            }
            throw new EMFMathException("Error in playsound() function: " + e.getMessage());
        }
    }

    protected boolean canOptimizeForConstantArgs() {
        return false;
    }

    protected boolean hasCorrectArgCount(int argCount) {
        return argCount == 3 || argCount == 6;
    }
}

