/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.compile.estimation.Average1DEstimator;

public final class MeshResultSize
extends Record
implements Average1DEstimator.Value<SectionCategory> {
    private final SectionCategory category;
    private final long resultSize;
    public static long NO_DATA = -1L;

    public MeshResultSize(SectionCategory category, long resultSize) {
        this.category = category;
        this.resultSize = resultSize;
    }

    @Override
    public SectionCategory category() {
        return this.category;
    }

    @Override
    public long value() {
        return this.resultSize;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MeshResultSize.class, "category;resultSize", "category", "resultSize"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MeshResultSize.class, "category;resultSize", "category", "resultSize"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MeshResultSize.class, "category;resultSize", "category", "resultSize"}, this, o);
    }

    public long resultSize() {
        return this.resultSize;
    }

    public static enum SectionCategory {
        LOW,
        UNDERGROUND,
        WATER_LEVEL,
        SURFACE,
        HIGH;


        public static SectionCategory forSection(RenderSection section, int seaLevelChunk) {
            int sectionY = section.getChunkY();
            if (sectionY == seaLevelChunk) {
                return WATER_LEVEL;
            }
            if (sectionY < seaLevelChunk - 4) {
                return LOW;
            }
            if (sectionY < seaLevelChunk) {
                return UNDERGROUND;
            }
            if (sectionY < seaLevelChunk + 3) {
                return SURFACE;
            }
            return HIGH;
        }
    }
}

