/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons;

import com.google.gson.Gson;
import io.github.thecsdev.tcdcommons.TCDCommonsConfig;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResourceManager;
import io.github.thecsdev.tcdcommons.api.util.io.mod.ModInfo;
import io.github.thecsdev.tcdcommons.api.util.io.mod.ModInfoProvider;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import io.github.thecsdev.tcdcommons.network.TCDCommonsNetwork;
import io.github.thecsdev.tcdcommons.server.TCDCommonsServer;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCDCommons {
    @ApiStatus.Internal
    public static final Gson GSON = new Gson();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)TCDCommons.getModID());
    public static final String ModID = "tcdcommons";
    private static TCDCommons Instance;
    protected final ModInfo modInfo;
    private final TCDCommonsConfig config;
    public final String userAgent;

    public TCDCommons() {
        if (TCDCommons.isModInitialized()) {
            throw new IllegalStateException(TCDCommons.getModID() + " has already been initialized.");
        }
        if (!TCDCommons.isInstanceValid(this)) {
            throw new UnsupportedOperationException("Invalid " + TCDCommons.getModID() + " type: " + this.getClass().getName());
        }
        Instance = this;
        this.modInfo = ModInfoProvider.getInstance().getModInfo(TCDCommons.getModID());
        this.userAgent = "TheCSDev (+https://github.com/TheCSDev) TCDCommonsAPI (+https://github.com/TheCSMods/mc-tcdcommons; +https://thecsdev.com/docs/tcdcommons/user-agent/)";
        LOGGER.info("Initializing '" + TCDCommons.getModName() + "' " + this.modInfo.getVersion() + " as '" + this.getClass().getSimpleName() + "'.");
        this.config = new TCDCommonsConfig(TCDCommons.getModID());
        this.config.loadFromFileOrCrash(true);
        TCDCommonsNetwork.init();
        CachedResourceManager.init();
    }

    public static TCDCommons getInstance() {
        return Instance;
    }

    public ModInfo getModInfo() {
        return this.modInfo;
    }

    public TCDCommonsConfig getConfig() {
        return this.config;
    }

    public static String getModName() {
        return TCDCommons.getInstance().getModInfo().getName().getString();
    }

    public static String getModID() {
        return ModID;
    }

    public static boolean isModInitialized() {
        return TCDCommons.isInstanceValid(Instance);
    }

    private static boolean isInstanceValid(TCDCommons instance) {
        return TCDCommons.isServer(instance) || TCDCommons.isClient(instance);
    }

    public static boolean isServer() {
        return TCDCommons.isServer(Instance);
    }

    public static boolean isClient() {
        return TCDCommons.isClient(Instance);
    }

    private static boolean isServer(TCDCommons arg0) {
        return arg0 instanceof TCDCommonsServer;
    }

    private static boolean isClient(TCDCommons arg0) {
        return arg0 instanceof TCDCommonsClient;
    }
}

