/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.other;

import io.github.thecsdev.tcdcommons.api.client.gui.other.TBlankElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UITexture;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TTextureElement
extends TBlankElement {
    @Nullable
    protected UITexture texture;
    protected final float[] textureColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public TTextureElement(int x, int y, int width, int height) {
        this(x, y, width, height, null);
    }

    public TTextureElement(int x, int y, int width, int height, UITexture texture) {
        super(x, y, width, height);
        this.texture = texture;
    }

    @Nullable
    public final UITexture getTexture() {
        return this.texture;
    }

    @Virtual
    public void setTexture(UITexture texture) {
        this.texture = texture;
    }

    public final float[] getTextureColor() {
        return this.textureColor;
    }

    public final void setTextureColor(float r, float g, float b) {
        this.setTextureColor(r, g, b, this.textureColor[3]);
    }

    @Virtual
    public void setTextureColor(float r, float g, float b, float a) {
        this.textureColor[0] = r;
        this.textureColor[1] = g;
        this.textureColor[2] = b;
        this.textureColor[3] = a;
    }

    @Override
    @Virtual
    public void render(TDrawContext pencil) {
        if (this.texture == null) {
            return;
        }
        pencil.pushTShaderColor(this.textureColor[0], this.textureColor[1], this.textureColor[2], this.textureColor[3]);
        this.texture.drawTexture(pencil);
        pencil.popTShaderColor();
    }
}

