/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.test;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.interfaces.IDataSyncer;
import fi.dy.masa.malilib.interfaces.IInventoryOverlayHandler;
import fi.dy.masa.malilib.mixin.entity.IMixinAbstractHorseEntity;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.InventoryOverlayContext;
import fi.dy.masa.malilib.render.InventoryOverlayRefresher;
import fi.dy.masa.malilib.test.TestDataSyncer;
import fi.dy.masa.malilib.test.TestRenderHandler;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.data.DataBlockUtils;
import fi.dy.masa.malilib.util.data.DataEntityUtils;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.converter.DataConverterNbt;
import fi.dy.masa.malilib.util.game.RayTraceUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1730;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2611;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3695;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6067;
import net.minecraft.class_7225;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class TestInventoryOverlayHandler
implements IInventoryOverlayHandler {
    private static final TestInventoryOverlayHandler INSTANCE = new TestInventoryOverlayHandler();
    IDataSyncer syncer = null;
    InventoryOverlay.Context context = null;
    InventoryOverlay.Refresher refresher = null;
    @ApiStatus.Experimental
    InventoryOverlayContext contextNew = null;
    @ApiStatus.Experimental
    InventoryOverlayRefresher refresherNew = null;

    public static TestInventoryOverlayHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public String getModId() {
        return "malilib";
    }

    @Override
    public IDataSyncer getDataSyncer() {
        if (this.syncer == null) {
            this.syncer = TestDataSyncer.getInstance();
        }
        return this.syncer;
    }

    @Override
    public void setDataSyncer(IDataSyncer syncer) {
        this.syncer = syncer;
    }

    @Override
    @ApiStatus.Experimental
    public boolean isNewCode() {
        return false;
    }

    @Override
    public InventoryOverlay.Refresher getRefreshHandler() {
        if (this.refresher == null) {
            this.refresher = new Refresher();
        }
        return this.refresher;
    }

    @Override
    @ApiStatus.Experimental
    public InventoryOverlayRefresher getRefreshHandlerNew() {
        if (this.refresherNew == null) {
            this.refresherNew = new RefresherNew();
        }
        return this.refresherNew;
    }

    @Override
    public boolean isEmpty() {
        if (this.isNewCode()) {
            return this.contextNew == null;
        }
        return this.context == null;
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getRenderContextNullable() {
        return this.context;
    }

    @Override
    @ApiStatus.Experimental
    @Nullable
    public InventoryOverlayContext getRenderContextNullableNew() {
        return this.contextNew;
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getRenderContext(class_332 drawContext, class_3695 profiler, class_310 mc) {
        profiler.method_15396(this.getClass().getName() + "_inventory_overlay");
        this.getTargetInventory(mc);
        if (!this.isEmpty()) {
            if (MaLiLibConfigs.Test.TEST_INVENTORY_OVERLAY_OG.getBooleanValue()) {
                TestRenderHandler.renderInventoryOverlayOG(drawContext, this.getRenderContextNullable(), mc);
            } else {
                this.renderInventoryOverlay(drawContext, this.getRenderContextNullable(), mc, true, true);
            }
        }
        profiler.method_15407();
        return this.getRenderContextNullable();
    }

    @Override
    @ApiStatus.Experimental
    @Nullable
    public InventoryOverlayContext getRenderContextNew(class_332 drawContext, class_3695 profiler, class_310 mc) {
        profiler.method_15396(this.getClass().getName() + "_inventory_overlay");
        this.getTargetInventoryNew(mc);
        if (!this.isEmpty()) {
            this.renderInventoryOverlayNew(drawContext, this.getRenderContextNullableNew(), mc, true, true);
        }
        profiler.method_15407();
        return this.getRenderContextNullableNew();
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getTargetInventory(class_310 mc) {
        class_1657 serverPlayer;
        class_1937 world = WorldUtils.getBestWorld(mc);
        class_1297 cameraEntity = EntityUtils.getCameraEntity();
        this.context = null;
        if (mc.field_1724 == null || world == null || mc.field_1687 == null) {
            return null;
        }
        if (cameraEntity == mc.field_1724 && world instanceof class_3218 && (serverPlayer = world.method_18470(mc.field_1724.method_5667())) != null) {
            cameraEntity = serverPlayer;
        }
        if (cameraEntity == null) {
            return null;
        }
        class_239 trace = cameraEntity != mc.field_1724 ? RayTraceUtils.getRayTraceFromEntity((class_1937)mc.field_1687, cameraEntity, class_3959.class_242.field_1348) : mc.field_1765;
        class_2487 nbt = new class_2487();
        if (trace == null || trace.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        if (trace.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)trace).method_17777();
            class_2680 state = world.method_8320(pos);
            class_2248 blockTmp = state.method_26204();
            class_2586 be = null;
            MaLiLib.LOGGER.warn("getTarget():1: pos [{}], state [{}]", (Object)pos.method_23854(), (Object)state.toString());
            if (blockTmp instanceof class_2343) {
                if (world instanceof class_3218) {
                    be = world.method_8500(pos).method_8321(pos);
                    if (be != null) {
                        nbt = be.method_38242((class_7225.class_7874)world.method_30349());
                    }
                } else {
                    Pair<class_2586, class_2487> pair = this.getDataSyncer().requestBlockEntity(world, pos);
                    if (pair != null) {
                        nbt = (class_2487)pair.getRight();
                    }
                }
                MaLiLib.LOGGER.warn("getTarget():2: pos [{}], be [{}], nbt [{}]", (Object)pos.method_23854(), (Object)(be != null ? 1 : 0), (Object)(nbt != null ? 1 : 0));
                return this.getTargetInventoryFromBlock(world, pos, be, nbt);
            }
            return null;
        }
        if (trace.method_17783() == class_239.class_240.field_1331) {
            class_1297 entity = ((class_3966)trace).method_17782();
            if (mc.field_1692 != null && entity.method_5628() != mc.field_1692.method_5628()) {
                MaLiLib.LOGGER.error("getTarget(): entityId Not Equal: [{} != {}]", (Object)entity.method_5628(), (Object)mc.field_1692.method_5628());
            }
            MaLiLib.LOGGER.warn("getTarget(): entityUUID [{}] vs targetedUUID [{}]", (Object)entity.method_5845(), (Object)(mc.field_1692 != null ? mc.field_1692.method_5845() : "<NULL>"));
            if (world instanceof class_3218) {
                if ((entity = world.method_8469(entity.method_5628())) != null) {
                    return this.getTargetInventoryFromEntity(entity, NbtEntityUtils.invokeEntityNbtDataNoPassengers(entity, entity.method_5628()));
                }
            } else {
                Pair<class_1297, class_2487> pair = this.getDataSyncer().requestEntity(world, entity.method_5628());
                if (pair != null) {
                    return this.getTargetInventoryFromEntity(world.method_8469(((class_1297)pair.getLeft()).method_5628()), (class_2487)pair.getRight());
                }
            }
        }
        return null;
    }

    @Override
    @ApiStatus.Experimental
    @Nullable
    public InventoryOverlayContext getTargetInventoryNew(class_310 mc) {
        class_1657 serverPlayer;
        class_1937 world = WorldUtils.getBestWorld(mc);
        class_1297 cameraEntity = EntityUtils.getCameraEntity();
        this.context = null;
        if (mc.field_1724 == null || world == null || mc.field_1687 == null) {
            return null;
        }
        if (cameraEntity == mc.field_1724 && world instanceof class_3218 && (serverPlayer = world.method_18470(mc.field_1724.method_5667())) != null) {
            cameraEntity = serverPlayer;
        }
        if (cameraEntity == null) {
            return null;
        }
        class_239 trace = cameraEntity != mc.field_1724 ? RayTraceUtils.getRayTraceFromEntity((class_1937)mc.field_1687, cameraEntity, class_3959.class_242.field_1348) : mc.field_1765;
        CompoundData data = new CompoundData();
        if (trace == null || trace.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        if (trace.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)trace).method_17777();
            class_2680 state = world.method_8320(pos);
            class_2248 blockTmp = state.method_26204();
            class_2586 be = null;
            MaLiLib.LOGGER.warn("getTargetNew():1: pos [{}], state [{}]", (Object)pos.method_23854(), (Object)state.toString());
            if (blockTmp instanceof class_2343) {
                if (world instanceof class_3218) {
                    be = world.method_8500(pos).method_8321(pos);
                    if (be != null) {
                        data = DataConverterNbt.fromVanillaCompound(be.method_38242((class_7225.class_7874)world.method_30349()));
                    }
                } else {
                    Pair<class_2586, CompoundData> pair = this.getDataSyncer().requestBlockEntityNew(world, pos);
                    if (pair != null) {
                        data = (CompoundData)pair.getRight();
                    }
                }
                MaLiLib.LOGGER.warn("getTargetNew():2: pos [{}], be [{}], data [{}]", (Object)pos.method_23854(), (Object)(be != null ? 1 : 0), (Object)(data != null ? 1 : 0));
                return this.getTargetInventoryFromBlockNew(world, pos, be, data);
            }
            return null;
        }
        if (trace.method_17783() == class_239.class_240.field_1331) {
            class_1297 entity = ((class_3966)trace).method_17782();
            if (mc.field_1692 != null && entity.method_5628() != mc.field_1692.method_5628()) {
                MaLiLib.LOGGER.error("getTargetNew(): entityId Not Equal: [{} != {}]", (Object)entity.method_5628(), (Object)mc.field_1692.method_5628());
            }
            MaLiLib.LOGGER.warn("getTargetNew(): entityUUID [{}] vs targetedUUID [{}]", (Object)entity.method_5845(), (Object)(mc.field_1692 != null ? mc.field_1692.method_5845() : "<NULL>"));
            if (world instanceof class_3218) {
                if ((entity = world.method_8469(entity.method_5628())) != null) {
                    return this.getTargetInventoryFromEntityNew(entity, DataEntityUtils.invokeEntityDataTagNoPassengers(entity, entity.method_5628()));
                }
            } else {
                Pair<class_1297, CompoundData> pair = this.getDataSyncer().requestEntityNew(world, entity.method_5628());
                if (pair != null) {
                    return this.getTargetInventoryFromEntityNew(world.method_8469(((class_1297)pair.getLeft()).method_5628()), (CompoundData)pair.getRight());
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getTargetInventoryFromBlock(class_1937 world, class_2338 pos, @Nullable class_2586 be, class_2487 nbt) {
        class_1657 player;
        class_2591<?> beType;
        class_1263 inv;
        if (be != null) {
            if (nbt.method_33133()) {
                nbt = be.method_38242((class_7225.class_7874)world.method_30349());
            }
            inv = InventoryUtils.getInventory(world, pos);
        } else {
            Pair<class_2586, class_2487> pair;
            if (nbt.method_33133() && (pair = this.getDataSyncer().requestBlockEntity(world, pos)) != null) {
                nbt = (class_2487)pair.getRight();
            }
            inv = this.getDataSyncer().getBlockInventory(world, pos, false);
        }
        class_2591<?> class_25912 = beType = nbt != null ? NbtBlockUtils.getBlockEntityTypeFromNbt(nbt) : null;
        if ((beType != null && beType.equals((Object)class_2591.field_11901) || be instanceof class_2611) && class_310.method_1551().field_1724 != null && (player = world.method_18470(class_310.method_1551().field_1724.method_5667())) != null) {
            Pair<class_1297, class_2487> enderPair = this.getDataSyncer().requestEntity(world, player.method_5628());
            class_1730 enderItems = null;
            if (enderPair != null && enderPair.getRight() != null && ((class_2487)enderPair.getRight()).method_10545("EnderItems")) {
                enderItems = InventoryUtils.getPlayerEnderItemsFromNbt((class_2487)enderPair.getRight(), world.method_30349());
            } else if (world instanceof class_3218) {
                enderItems = player.method_7274();
            }
            if (enderItems != null) {
                inv = enderItems;
            }
        }
        if (nbt != null && !nbt.method_33133()) {
            class_1263 inv2 = InventoryUtils.getNbtInventory(nbt, inv != null ? inv.method_5439() : -1, world.method_30349());
            if (inv == null) {
                inv = inv2;
            }
        }
        MaLiLib.LOGGER.warn("getTarget():3: pos [{}], inv [{}], be [{}], nbt [{}]", (Object)pos.method_23854(), (Object)(inv != null ? 1 : 0), (Object)(be != null ? 1 : 0), (Object)(nbt != null ? nbt.method_10558("id") : new class_2487()));
        if (inv == null || nbt == null) {
            return null;
        }
        this.context = new InventoryOverlay.Context(InventoryOverlay.getBestInventoryType(inv, nbt), inv, be != null ? be : world.method_8321(pos), null, nbt, this.getRefreshHandler());
        return this.context;
    }

    @Override
    @ApiStatus.Experimental
    @Nullable
    public InventoryOverlayContext getTargetInventoryFromBlockNew(class_1937 world, class_2338 pos, @Nullable class_2586 be, CompoundData data) {
        class_1657 player;
        class_2591<?> beType;
        class_1263 inv;
        if (be != null) {
            if (data.isEmpty()) {
                data = DataConverterNbt.fromVanillaCompound(be.method_38242((class_7225.class_7874)world.method_30349()));
            }
            inv = InventoryUtils.getInventory(world, pos);
        } else {
            Pair<class_2586, CompoundData> pair;
            if (data.isEmpty() && (pair = this.getDataSyncer().requestBlockEntityNew(world, pos)) != null) {
                data = (CompoundData)pair.getRight();
            }
            inv = this.getDataSyncer().getBlockInventoryNew(world, pos, false);
        }
        MaLiLib.LOGGER.error("getTargetFromBlockNew: inv [{}], data [{}]", inv != null ? Integer.valueOf(inv.method_5439()) : "<NULL>", (Object)(data != null ? data.toString() : "<NULL>"));
        class_2591<?> class_25912 = beType = data != null ? DataBlockUtils.getBlockEntityType(data) : null;
        if ((beType != null && beType.equals((Object)class_2591.field_11901) || be instanceof class_2611) && class_310.method_1551().field_1724 != null && (player = world.method_18470(class_310.method_1551().field_1724.method_5667())) != null) {
            Pair<class_1297, CompoundData> enderPair = this.getDataSyncer().requestEntityNew(world, player.method_5628());
            class_1730 enderItems = null;
            if (enderPair != null && enderPair.getRight() != null && ((CompoundData)enderPair.getRight()).contains("EnderItems", 9)) {
                enderItems = InventoryUtils.getPlayerEnderItemsFromData((CompoundData)enderPair.getRight(), world.method_30349());
            } else if (world instanceof class_3218) {
                enderItems = player.method_7274();
            }
            if (enderItems != null) {
                inv = enderItems;
            }
        }
        if (data != null && !data.isEmpty()) {
            class_1263 inv2 = InventoryUtils.getDataInventory(data, inv != null ? inv.method_5439() : -1, world.method_30349());
            if (inv == null) {
                inv = inv2;
            }
        }
        MaLiLib.LOGGER.warn("getTargetFromBlockNew():3: pos [{}], inv [{}], be [{}], data [{}]", (Object)pos.method_23854(), (Object)(inv != null ? 1 : 0), (Object)(be != null ? 1 : 0), data != null ? data.getString("id") : new CompoundData());
        if (inv == null || data == null) {
            return null;
        }
        this.contextNew = new InventoryOverlayContext(InventoryOverlay.getBestInventoryTypeNew(inv, data), inv, be != null ? be : world.method_8321(pos), null, data, this.getRefreshHandlerNew());
        return this.contextNew;
    }

    @Override
    @Nullable
    public InventoryOverlay.Context getTargetInventoryFromEntity(class_1297 entity, class_2487 nbt) {
        class_1263 inv = null;
        class_1309 entityLivingBase = null;
        if (entity instanceof class_1309) {
            entityLivingBase = (class_1309)entity;
        }
        if (entity instanceof class_1263) {
            inv = (class_1263)entity;
        } else if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            inv = new class_1277((class_1799[])player.method_31548().method_67533().toArray((Object[])new class_1799[36]));
        } else if (entity instanceof class_1496) {
            inv = ((IMixinAbstractHorseEntity)entity).malilib_getHorseInventory();
        } else if (entity instanceof class_6067) {
            inv = ((class_6067)entity).method_35199();
        }
        if (!nbt.method_33133()) {
            class_1263 inv2;
            if (inv != null && nbt.method_10545("Items") && nbt.method_10554("Items").orElse(new class_2499()).size() > 1) {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntity(): [Fix for horse inv] inv.size: [{}]", (Object)inv.method_5439());
                inv2 = entity instanceof class_1496 ? InventoryUtils.getNbtInventoryHorseFix(nbt, inv.method_5439(), entity.method_56673()) : InventoryUtils.getNbtInventory(nbt, inv.method_5439(), entity.method_56673());
                inv = null;
            } else if (inv != null && nbt.method_10545("equipment") && nbt.method_10545("EatingHaystack")) {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntity(): [Fix for saddled horse inv] inv.size: [{}]", (Object)inv.method_5439());
                inv2 = InventoryUtils.getNbtInventoryHorseFix(nbt, inv.method_5439(), entity.method_56673());
                inv = null;
            } else if (inv != null && inv.method_5439() == 8 && nbt.method_10545("Inventory") && !nbt.method_10554("Inventory").orElse(new class_2499()).isEmpty()) {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntity(): [Fix for empty villager/piglin inv] inv.size: [{}]", (Object)inv.method_5439());
                inv2 = InventoryUtils.getNbtInventory(nbt, 8, entity.method_56673());
                inv = null;
            } else {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntity(): [Default] inv.size: [{}]", (Object)(inv != null ? inv.method_5439() : -1));
                inv2 = InventoryUtils.getNbtInventory(nbt, inv != null ? inv.method_5439() : -1, entity.method_56673());
                if (inv2 != null) {
                    inv = null;
                }
            }
            MaLiLib.LOGGER.error("getTargetInventoryFromEntity(): inv.size [{}], inv2.size [{}]", inv != null ? Integer.valueOf(inv.method_5439()) : "null", inv2 != null ? Integer.valueOf(inv2.method_5439()) : "null");
            if (inv2 != null) {
                inv = inv2;
            }
        }
        if (inv == null && entityLivingBase == null) {
            return null;
        }
        this.context = new InventoryOverlay.Context(inv != null ? InventoryOverlay.getBestInventoryType(inv, nbt) : InventoryOverlay.getInventoryType(nbt), inv, null, entityLivingBase, nbt, this.getRefreshHandler());
        return this.context;
    }

    @Override
    @ApiStatus.Experimental
    @Nullable
    public InventoryOverlayContext getTargetInventoryFromEntityNew(class_1297 entity, CompoundData data) {
        class_1263 inv = null;
        class_1309 entityLivingBase = null;
        if (entity instanceof class_1309) {
            entityLivingBase = (class_1309)entity;
        }
        if (entity instanceof class_1263) {
            inv = (class_1263)entity;
        } else if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            inv = new class_1277((class_1799[])player.method_31548().method_67533().toArray((Object[])new class_1799[36]));
        } else if (entity instanceof class_1496) {
            inv = ((IMixinAbstractHorseEntity)entity).malilib_getHorseInventory();
        } else if (entity instanceof class_6067) {
            inv = ((class_6067)entity).method_35199();
        }
        if (!data.isEmpty()) {
            class_1263 inv2;
            if (inv != null && data.contains("Items", 9) && data.getList("Items").size() > 1) {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntityNew(): [Fix for horse inv] inv.size: [{}]", (Object)inv.method_5439());
                inv2 = entity instanceof class_1496 ? InventoryUtils.getDataInventoryHorseFix(data, inv.method_5439(), entity.method_56673()) : InventoryUtils.getDataInventory(data, inv.method_5439(), entity.method_56673());
                inv = null;
            } else if (inv != null && data.containsLenient("equipment") && data.containsLenient("EatingHaystack")) {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntityNew(): [Fix for saddled horse inv] inv.size: [{}]", (Object)inv.method_5439());
                inv2 = InventoryUtils.getDataInventoryHorseFix(data, inv.method_5439(), entity.method_56673());
                inv = null;
            } else if (inv != null && inv.method_5439() == 8 && data.contains("Inventory", 9) && !data.getList("Inventory").isEmpty()) {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntityNew(): [Fix for empty villager/piglin inv] inv.size: [{}]", (Object)inv.method_5439());
                inv2 = InventoryUtils.getDataInventory(data, 8, entity.method_56673());
                inv = null;
            } else {
                MaLiLib.LOGGER.warn("getTargetInventoryFromEntityNew(): [Default] inv.size: [{}]", (Object)(inv != null ? inv.method_5439() : -1));
                inv2 = InventoryUtils.getDataInventory(data, inv != null ? inv.method_5439() : -1, entity.method_56673());
                if (inv2 != null) {
                    inv = null;
                }
            }
            MaLiLib.LOGGER.error("getTargetInventoryFromEntityNew(): inv.size [{}], inv2.size [{}]", inv != null ? Integer.valueOf(inv.method_5439()) : "null", inv2 != null ? Integer.valueOf(inv2.method_5439()) : "null");
            if (inv2 != null) {
                inv = inv2;
            }
        }
        if (inv == null && entityLivingBase == null) {
            return null;
        }
        this.contextNew = new InventoryOverlayContext(inv != null ? InventoryOverlay.getBestInventoryTypeNew(inv, data) : InventoryOverlay.getInventoryTypeNew(data), inv, null, entityLivingBase, data, this.getRefreshHandlerNew());
        return this.contextNew;
    }

    public static class Refresher
    implements InventoryOverlay.Refresher {
        @Override
        public InventoryOverlay.Context onContextRefresh(InventoryOverlay.Context data, class_1937 world) {
            if (data.be() != null) {
                TestInventoryOverlayHandler.getInstance().requestBlockEntityAt(world, data.be().method_11016());
                data = TestInventoryOverlayHandler.getInstance().getTargetInventoryFromBlock(data.be().method_10997(), data.be().method_11016(), data.be(), data.nbt());
            } else if (data.entity() != null) {
                TestInventoryOverlayHandler.getInstance().getDataSyncer().requestEntity(world, data.entity().method_5628());
                data = TestInventoryOverlayHandler.getInstance().getTargetInventoryFromEntity((class_1297)data.entity(), data.nbt());
            }
            return data;
        }
    }

    @ApiStatus.Experimental
    public static class RefresherNew
    implements InventoryOverlayRefresher {
        @Override
        @ApiStatus.Experimental
        public InventoryOverlayContext onContextRefresh(InventoryOverlayContext data, class_1937 world) {
            if (data.be() != null) {
                TestInventoryOverlayHandler.getInstance().requestBlockEntityAtNew(world, data.be().method_11016());
                data = TestInventoryOverlayHandler.getInstance().getTargetInventoryFromBlockNew(data.be().method_10997(), data.be().method_11016(), data.be(), data.data());
            } else if (data.entity() != null) {
                TestInventoryOverlayHandler.getInstance().getDataSyncer().requestEntityNew(world, data.entity().method_5628());
                data = TestInventoryOverlayHandler.getInstance().getTargetInventoryFromEntityNew((class_1297)data.entity(), data.data());
            }
            return data;
        }
    }
}

