/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.other;

import io.github.thecsdev.tcdcommons.api.client.gui.other.TBlankElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.client.ClientEntitySandbox;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5489;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Deprecated(since="3.12.8")
@Virtual
public class TEntityRendererElement
extends TBlankElement {
    @Nullable
    protected class_1297 entity;
    @Nullable
    protected class_5489 entityTypeName;
    protected boolean entityErrorState;
    protected int entityTextX;
    protected int entityTextY;
    protected int entityDisplaySize;
    protected double entityScale;
    protected boolean followsCursor;
    public static final Map<class_1299<?>, Supplier<Double>> EntityGuiSizeOffsets = new HashMap();

    public TEntityRendererElement(int x, int y, int width, int height) {
        this(x, y, width, height, null);
    }

    public TEntityRendererElement(int x, int y, int width, int height, class_1299<?> entityType) {
        super(x, y, width, height);
        this.setEntityScale(0.9);
        this.setFollowsCursor(true);
        this.setEntity(entityType);
        if (entityType != class_1299.field_6097) {
            this.entityErrorState = true;
        }
    }

    @Override
    @Virtual
    public void setSize(int width, int height, int flags) {
        super.setSize(width, height, flags);
        this.recalcCache_mobSize();
    }

    @Nullable
    public final class_1297 getEntity() {
        return this.entity;
    }

    @Nullable
    public final class_1299<?> getEntityType() {
        return this.entity != null ? this.entity.method_5864() : null;
    }

    public final void setEntity(@Nullable class_1299<?> entityType) {
        class_1297 entity = ClientEntitySandbox.getCachedEntityFromType(entityType);
        this.setEntity(entity);
        if (entity == null) {
            this.entityErrorState = true;
            if (entityType != null) {
                this.updateEntityTypeName(entityType);
            }
        }
    }

    public final void setEntity(@Nullable class_1297 entity) {
        this.entity = entity;
        this.updateEntityTypeName(this.getEntityType());
        this.entityErrorState = false;
        this.recalcCache_mobSize();
    }

    @ApiStatus.Internal
    protected final void updateEntityTypeName(class_1299<?> entityType) {
        class_327 textRenderer = TCDCommonsClient.MC_CLIENT.field_1772;
        this.entityTypeName = entityType != null ? class_5489.method_30890((class_327)textRenderer, (class_2561)entityType.method_5897(), (int)this.width) : class_5489.method_30892((class_327)textRenderer, (class_2561[])new class_2561[]{TextUtils.literal("-")});
    }

    public final boolean getFollowsCursor() {
        return this.followsCursor;
    }

    @Virtual
    public void setFollowsCursor(boolean followsCursor) {
        this.followsCursor = followsCursor;
    }

    public final double getEntityScale() {
        return this.entityScale;
    }

    public final void setEntityScale(double entityScale) {
        this.entityScale = class_3532.method_15350((double)entityScale, (double)0.1, (double)5.0);
        this.recalcCache_mobSize();
    }

    protected final void recalcCache_mobSize() {
        if (this.entity == null) {
            this.entityDisplaySize = 30;
            return;
        }
        int viewportSize = Math.min(this.width, this.height);
        this.entityDisplaySize = (int)((double)TEntityRendererElement.calculateEntityGUISize(this.entity, viewportSize) * this.entityScale);
    }

    protected final void recalcCache_cXY() {
        this.entityTextX = this.x + this.width / 2;
        if (this.entityTypeName != null) {
            Objects.requireNonNull(TCDCommonsClient.MC_CLIENT.field_1772);
            int fh = 9;
            this.entityTextY = this.getY() + this.getHeight() / 2 + fh / 2 - this.entityTypeName.method_30887() * fh;
        } else {
            this.entityTextY = this.getEndY() - this.height / 4;
        }
    }

    @Override
    @Virtual
    public void render(TDrawContext pencil) {
        this.recalcCache_cXY();
        if (this.entityErrorState || this.entity == null) {
            if (this.entityTypeName != null) {
                Objects.requireNonNull(TCDCommonsClient.MC_CLIENT.field_1772);
                this.entityTypeName.method_73212((class_332)pencil, class_5489.class_11735.field_62010, this.entityTextX, this.entityTextY, 9, false, -1);
            } else {
                pencil.drawTFill(-65281);
            }
            return;
        }
        try {
            pencil.drawTEntity(this.entity, this.x, this.y, this.width, this.height, this.entityDisplaySize, this.followsCursor);
        }
        catch (Exception e) {
            this.entityErrorState = true;
        }
    }

    public static double getEntityGuiSizeOffset(class_1299<?> entityType) {
        return EntityGuiSizeOffsets.getOrDefault(entityType, () -> 1.0).get();
    }

    public static int calculateEntityGUISize(class_1297 entity, int viewportSize) {
        float f2;
        int maxVal = (int)(50.0f * ((float)viewportSize / 80.0f));
        if (entity == null) {
            return maxVal;
        }
        int result = maxVal;
        float f1 = entity.method_5864().method_18386().comp_2185();
        double d0 = Math.sqrt(f1 * f1 + (f2 = entity.method_5864().method_18386().comp_2186()) * f2);
        if (d0 == 0.0) {
            d0 = 0.1;
        }
        result = (int)((double)maxVal / d0);
        result = (int)((double)result * TEntityRendererElement.getEntityGuiSizeOffset(entity.method_5864()));
        return result;
    }

    static {
        EntityGuiSizeOffsets.put(class_1299.field_6116, () -> 4.0);
    }
}

