/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import io.github.thecsdev.tcdcommons.client.mixin.hooks.AccessorCheckboxWidget;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TCheckboxWidget
extends TButtonWidget {
    public static final class_2960 SELECTED_HIGHLIGHTED_TEXTURE = AccessorCheckboxWidget.getSelectedHighlightedTexture();
    public static final class_2960 SELECTED_TEXTURE = AccessorCheckboxWidget.getSelectedTexture();
    public static final class_2960 HIGHLIGHTED_TEXTURE = AccessorCheckboxWidget.getHighlightedTexture();
    public static final class_2960 TEXTURE = AccessorCheckboxWidget.getTexture();
    protected boolean checked = false;
    protected boolean showText;
    protected HorizontalAlignment textAlignment;
    protected HorizontalAlignment checkboxAlignment;
    protected int cX;
    protected int cY;
    protected int tX;
    protected int tY;

    public TCheckboxWidget(int x, int y, int width, int height) {
        this(x, y, width, height, null);
    }

    public TCheckboxWidget(int x, int y, int width, int height, class_2561 text) {
        this(x, y, width, height, text, false);
    }

    public TCheckboxWidget(int x, int y, int width, int height, class_2561 text, boolean checked) {
        super(x, y, width, height, null);
        this.checked = checked;
        this.showText = true;
        this.textAlignment = HorizontalAlignment.LEFT;
        this.checkboxAlignment = HorizontalAlignment.LEFT;
        this.setText(text);
    }

    public final boolean getChecked() {
        return this.checked;
    }

    @Virtual
    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public final boolean getShowText() {
        return this.showText;
    }

    @Virtual
    public void setShowText(boolean showText) {
        this.showText = showText;
    }

    @Override
    @Virtual
    protected void onClick() {
        this.checked = !this.checked;
        super.onClick();
    }

    @Override
    public void setText(@Nullable class_2561 text) {
        super.setText(text);
        this.setHorizontalAlignment(this.textAlignment, this.checkboxAlignment);
    }

    public final void setHorizontalAlignment(HorizontalAlignment forText, HorizontalAlignment forCheckbox) {
        if (forCheckbox == HorizontalAlignment.CENTER) {
            forCheckbox = HorizontalAlignment.LEFT;
        }
        class_327 tr = TCDCommonsClient.MC_CLIENT.field_1772;
        this.textAlignment = forText;
        this.checkboxAlignment = forCheckbox;
        class_2561 txt = this.getText();
        int x1 = this.x;
        int x2 = this.x + this.width;
        int msgW = txt != null ? tr.method_30880(txt.method_30937()) : 0;
        this.cX = forCheckbox == HorizontalAlignment.RIGHT ? x2 - 20 : x1;
        this.cY = this.y;
        if (forCheckbox == HorizontalAlignment.LEFT) {
            x1 += 25;
        } else {
            x2 -= 25;
        }
        switch (forText) {
            case LEFT: {
                this.tX = x1;
                break;
            }
            case RIGHT: {
                this.tX = x2 - msgW;
                break;
            }
            case CENTER: {
                this.tX = (x1 + x2) / 2 - msgW / 2;
                break;
            }
            default: {
                this.tX = x1;
            }
        }
        int n = this.y + this.height / 2;
        Objects.requireNonNull(tr);
        this.tY = n - 9 / 2;
        this.tX -= this.x;
        this.tY -= this.y;
        this.cX -= this.x;
        this.cY -= this.y;
    }

    @Override
    public void render(TDrawContext pencil) {
        class_327 textRenderer = this.getTextRenderer();
        pencil.drawTCheckbox(this.x + this.cX, this.y + this.cY, 20, this.height, this.isFocusedOrHovered(), this.checked);
        if (this.showText) {
            if (this.textAlignment != HorizontalAlignment.CENTER) {
                pencil.method_27535(textRenderer, this.getText(), this.x + this.tX, this.y + this.tY, -2039584);
            } else {
                pencil.method_27534(textRenderer, this.getText(), this.x + this.tX, this.y + this.tY, -2039584);
            }
        }
    }
}

