/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.integrity;

import java.util.Locale;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class IntegrityUtils {
    private IntegrityUtils() {
    }

    @Nullable
    public static final String getJarFileName(Class<?> containingClass) throws NullPointerException, SecurityException {
        Objects.requireNonNull(containingClass);
        String path = containingClass.getProtectionDomain().getCodeSource().getLocation().getPath().replace('\\', '/');
        if (!path.contains("/") || !path.toLowerCase(Locale.ENGLISH).endsWith(".jar")) {
            return null;
        }
        return path.substring(path.lastIndexOf(47));
    }
}

