/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.io.repo.github;

import io.github.thecsdev.tcdcommons.api.util.io.repo.RepositoryInfoProvider;
import io.github.thecsdev.tcdcommons.api.util.io.repo.RepositoryUserInfo;
import io.github.thecsdev.tcdcommons.api.util.io.repo.github.GitHubHostInfo;
import io.github.thecsdev.tcdcommons.api.util.io.repo.ugc.RepositoryInfo;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Deprecated(since="v3.12", forRemoval=true)
public final class GitHubRepositoryInfoProvider
extends RepositoryInfoProvider {
    private static final GitHubRepositoryInfoProvider INSTANCE = new GitHubRepositoryInfoProvider();

    private GitHubRepositoryInfoProvider() {
    }

    public static final GitHubRepositoryInfoProvider getInstance() {
        return INSTANCE;
    }

    @ApiStatus.Internal
    private static final boolean assertSupportedHost(URI uri) throws NullPointerException {
        String host = Objects.requireNonNull(uri).getHost();
        return Objects.equals(host, "github.com") || Objects.equals(host, "www.github.com");
    }

    @Override
    @Nullable
    public final RepositoryInfo fetchRepoInfoSync(URI repoUri) throws NullPointerException, IOException {
        if (!GitHubRepositoryInfoProvider.assertSupportedHost(repoUri)) {
            return null;
        }
        String[] path = GitHubRepositoryInfoProvider.getUriPathEntries(repoUri);
        if (path.length < 2) {
            throw new IOException("Unable to fetch GitHub repository info.", new IllegalArgumentException(String.format("The given URI's path is invalid '%s'.", repoUri.getPath())));
        }
        return GitHubHostInfo.getInstance().fetchRepoInfoByNameSync(path[0], path[1]);
    }

    @Override
    @Nullable
    public final RepositoryUserInfo fetchUserInfoSync(URI userUri) throws NullPointerException, IOException {
        if (!GitHubRepositoryInfoProvider.assertSupportedHost(userUri)) {
            return null;
        }
        String[] path = GitHubRepositoryInfoProvider.getUriPathEntries(userUri);
        if (path.length < 1) {
            throw new IOException("Unable to fetch GitHub user info.", new IllegalArgumentException(String.format("The given URI's path is invalid '%s'.", userUri.getPath())));
        }
        return GitHubHostInfo.getInstance().fetchUserInfoByNameSync(path[0]);
    }
}

